/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.jobs;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.datetime.DateTimeService;
import org.hawkular.metrics.scheduler.api.JobDetails;
import org.hawkular.metrics.scheduler.api.Trigger;
import org.hawkular.metrics.sysconfig.Configuration;
import org.hawkular.metrics.sysconfig.ConfigurationService;
import org.jboss.logging.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import rx.Completable;
import rx.functions.Func1;

public class TempDataCompressor
implements Func1<JobDetails, Completable> {
    private static Logger logger = Logger.getLogger(TempDataCompressor.class);
    public static final String JOB_NAME = "TEMP_DATA_COMPRESSOR";
    public static final String CONFIG_ID = "org.hawkular.metrics.jobs.TEMP_DATA_COMPRESSOR";
    public static final String CONFIG_PAGE_SIZE = "page-size";
    public static final String CONFIG_MAX_READ_CONCURRENCY = "concurrency.read.max";
    private static final int DEFAULT_PAGE_SIZE = 1000;
    private static final int DEFAULT_READ_CONCURRENCY = 2;
    private MetricsService metricsService;
    private int pageSize;
    private boolean enabled;
    private int maxReadConcurrency = 2;

    public TempDataCompressor(MetricsService service, ConfigurationService configurationService) {
        this.metricsService = service;
        Configuration configuration = (Configuration)configurationService.load(CONFIG_ID).toSingle().toBlocking().value();
        this.pageSize = configuration.get(CONFIG_PAGE_SIZE) == null ? 1000 : Integer.parseInt(configuration.get(CONFIG_PAGE_SIZE));
        if (configuration.get(CONFIG_MAX_READ_CONCURRENCY) != null) {
            this.maxReadConcurrency = Integer.parseInt(configuration.get(CONFIG_MAX_READ_CONCURRENCY));
        }
        String enabledConfig = configuration.get("enabled", "true");
        this.enabled = Boolean.parseBoolean(enabledConfig);
        logger.debugf("Job enabled? %b", (Object)this.enabled);
    }

    public Completable call(JobDetails jobDetails) {
        Duration runtimeBlockSize = Duration.standardHours(2L);
        Trigger trigger = jobDetails.getTrigger();
        DateTime timeSliceInclusive = new DateTime(trigger.getTriggerTime(), DateTimeZone.UTC).minus(runtimeBlockSize);
        DateTime timeSliceStart = DateTimeService.getTimeSlice(timeSliceInclusive, runtimeBlockSize);
        long startOfSlice = timeSliceStart.getMillis();
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.infof("Starting to process temp table for starting time of %s", (Object)timeSliceStart.toString());
        return this.metricsService.compressBlock(startOfSlice, this.pageSize, this.maxReadConcurrency).doOnError(t -> logger.errorf("Compression job failed: %s", (Object)t.getMessage())).doOnCompleted(() -> {
            stopwatch.stop();
            logger.info((Object)("Finished processing data in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
        });
    }
}

