/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.transformers;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import rx.Observable;
import rx.functions.Func0;

public class BoundBatchStatementTransformer
implements Observable.Transformer<BoundStatement, BatchStatement> {
    public static final int DEFAULT_BATCH_SIZE = 50;
    public static final Func0<BatchStatement> DEFAULT_BATCH_STATEMENT_FACTORY = () -> new BatchStatement(BatchStatement.Type.UNLOGGED);
    private final Func0<BatchStatement> batchStatementFactory;
    private final int batchSize;

    public BoundBatchStatementTransformer() {
        this(DEFAULT_BATCH_STATEMENT_FACTORY, 50);
    }

    public BoundBatchStatementTransformer(Func0<BatchStatement> batchStatementFactory, int batchSize) {
        this.batchSize = batchSize;
        this.batchStatementFactory = batchStatementFactory;
    }

    public Observable<BatchStatement> call(Observable<BoundStatement> statements) {
        return statements.window(this.batchSize).flatMap(window -> window.collect(this.batchStatementFactory, BatchStatement::add));
    }
}

