/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.sysconfig;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Statement;
import java.util.Map;
import org.hawkular.metrics.sysconfig.Configuration;
import org.hawkular.rx.cassandra.driver.RxSession;
import rx.Completable;
import rx.Observable;
import rx.Scheduler;

public class ConfigurationService {
    private RxSession session;
    private PreparedStatement findConfigurationGroup;
    private PreparedStatement findConfigurationValue;
    private PreparedStatement updateConfigurationValue;
    private PreparedStatement deleteConfigurationValue;
    private PreparedStatement deleteConfiguration;

    public void init(RxSession session) {
        this.session = session;
        this.findConfigurationGroup = session.getSession().prepare("SELECT name, value FROM sys_config WHERE config_id = ?").setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.findConfigurationValue = session.getSession().prepare("SELECT value FROM sys_config WHERE config_id = ? AND name= ?").setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.updateConfigurationValue = session.getSession().prepare("INSERT INTO sys_config (config_id, name, value) VALUES (?, ?, ?)").setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.deleteConfigurationValue = session.getSession().prepare("DELETE FROM sys_config WHERE config_id =? and name = ?").setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.deleteConfiguration = session.getSession().prepare("DELETE FROM sys_config WHERE config_id = ?").setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
    }

    public Observable<Configuration> load(String id) {
        return this.session.executeAndFetch((Statement)this.findConfigurationGroup.bind(id)).toMap(row -> row.getString(0), row -> row.getString(1)).map(map -> new Configuration(id, (Map<String, String>)map));
    }

    public Observable<String> load(String id, String name) {
        return this.session.executeAndFetch((Statement)this.findConfigurationValue.bind(id, name)).map(row -> row.getString(0));
    }

    public Observable<Configuration> load(String id, Scheduler scheduler) {
        return this.session.executeAndFetch((Statement)this.updateConfigurationValue.bind(id), scheduler).toMap(row -> row.getString(0), row -> row.getString(1)).map(map -> new Configuration(id, (Map<String, String>)map));
    }

    public Observable<Void> save(Configuration configuration) {
        return Observable.from(configuration.getProperties().entrySet()).map(entry -> this.updateConfigurationValue.bind(configuration.getId(), entry.getKey(), entry.getValue())).collect(() -> new BatchStatement(BatchStatement.Type.UNLOGGED), BatchStatement::add).flatMap(batch -> this.session.execute((Statement)batch).map(resultSet -> null));
    }

    public Observable<Void> save(String configId, String name, String value) {
        return this.session.execute((Statement)this.updateConfigurationValue.bind(configId, name, value)).map(resultSet -> null);
    }

    public Observable<Void> save(String configId, String name, String value, Scheduler scheduler) {
        return this.session.execute((Statement)this.updateConfigurationValue.bind(configId, name, value), scheduler).map(resultSet -> null);
    }

    public Completable delete(String configId, String name) {
        return this.session.execute((Statement)this.deleteConfigurationValue.bind(configId, name)).toCompletable();
    }

    public Completable delete(String configId) {
        return this.session.execute((Statement)this.deleteConfiguration.bind(configId)).toCompletable();
    }
}

