/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.scheduler.api;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.hawkular.metrics.scheduler.api.Trigger;

public class JobDetails {
    private UUID jobId;
    private String jobType;
    private String jobName;
    private Map<String, String> parameters;
    private Trigger trigger;

    public JobDetails(UUID jobId, String jobType, String jobName, Map<String, String> parameters, Trigger trigger) {
        this.jobId = jobId;
        this.jobType = jobType;
        this.jobName = jobName;
        this.parameters = Collections.unmodifiableMap(parameters);
        this.trigger = trigger;
    }

    public UUID getJobId() {
        return this.jobId;
    }

    public String getJobType() {
        return this.jobType;
    }

    public String getJobName() {
        return this.jobName;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDetails that = (JobDetails)o;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.jobType, that.jobType) && Objects.equals(this.jobName, that.jobName) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.trigger, that.trigger);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.jobType, this.jobName, this.parameters, this.trigger);
    }

    public String toString() {
        return "JobDetails{jobId=" + this.jobId + ", jobType='" + this.jobType + '\'' + ", jobName='" + this.jobName + '\'' + ", parameters=" + this.parameters + ", trigger=" + this.trigger + '}';
    }
}

