/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.scheduler.impl;

import com.datastax.driver.core.PreparedStatement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.datetime.DateTimeService;
import org.hawkular.metrics.scheduler.api.JobDetails;
import org.hawkular.metrics.scheduler.api.RetryPolicy;
import org.hawkular.metrics.scheduler.api.Trigger;
import org.hawkular.metrics.scheduler.impl.SchedulerImpl;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;
import rx.Scheduler;
import rx.Single;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.schedulers.Schedulers;
import rx.subjects.PublishSubject;

public class TestScheduler
implements org.hawkular.metrics.scheduler.api.Scheduler {
    private RxSession session;
    private SchedulerImpl scheduler;
    private rx.schedulers.TestScheduler tickScheduler;
    private PublishSubject<Date> finishedTimeSlices;
    private PublishSubject<JobDetails> jobFinished;
    private List<Subscription> finishedTimeSlicesSubscriptions;
    private List<Subscription> jobFinishedSubscriptions;
    private PreparedStatement insertJob;
    private PreparedStatement updateJobQueue;

    TestScheduler() {
    }

    public TestScheduler(RxSession session) {
        this.session = session;
        this.finishedTimeSlices = PublishSubject.create();
        this.jobFinished = PublishSubject.create();
        this.finishedTimeSlicesSubscriptions = new ArrayList<Subscription>();
        this.jobFinishedSubscriptions = new ArrayList<Subscription>();
        this.insertJob = session.getSession().prepare("INSERT INTO jobs (id, type, name, params, trigger) VALUES (?, ?, ?, ?, ?)");
        this.updateJobQueue = session.getSession().prepare("INSERT INTO scheduled_jobs_idx (time_slice, job_id) VALUES (?, ?)");
        this.initTickScheduler();
        this.initJobScheduler();
    }

    @Override
    public Single<JobDetails> scheduleJob(String type, String name, Map<String, String> parameters, Trigger trigger) {
        return this.scheduler.scheduleJob(type, name, parameters, trigger);
    }

    @Override
    public void register(String jobType, Func1<JobDetails, Completable> factory) {
        this.scheduler.register(jobType, factory);
    }

    @Override
    public void register(String jobType, Func1<JobDetails, Completable> jobProducer, Func2<JobDetails, Throwable, RetryPolicy> retryFunction) {
        this.scheduler.register(jobType, jobProducer, retryFunction);
    }

    @Override
    public void start() {
        this.scheduler.start();
    }

    public void truncateTables(String keyspace) {
        this.session.execute("select table_name from system_schema.tables where keyspace_name = '" + keyspace + "'").flatMap(Observable::from).filter(row -> !row.getString(0).equals("cassalog") && !row.getString(0).equals("sys_config")).flatMap(row -> this.session.execute("truncate " + row.getString(0))).toCompletable().await(10L, TimeUnit.SECONDS);
    }

    private void initJobScheduler() {
        this.scheduler = new SchedulerImpl(this.session);
        this.scheduler.setTickScheduler((Scheduler)this.tickScheduler);
        this.scheduler.setTimeSlicesSubject(this.finishedTimeSlices);
        this.scheduler.setJobFinishedSubject(this.jobFinished);
    }

    private void initTickScheduler() {
        DateTimeService.now = DateTime::now;
        this.tickScheduler = Schedulers.test();
        this.tickScheduler.advanceTimeTo(DateTimeService.currentMinute().getMillis(), TimeUnit.MILLISECONDS);
        DateTimeService.now = () -> new DateTime(this.tickScheduler.now());
    }

    @Override
    public void shutdown() {
        this.finishedTimeSlicesSubscriptions.forEach(Subscription::unsubscribe);
        this.jobFinishedSubscriptions.forEach(Subscription::unsubscribe);
        Schedulers.reset();
        this.scheduler.shutdown();
    }

    @Override
    public Observable<JobDetails> getAllJobs() {
        return this.scheduler.getAllJobs();
    }

    public void onTimeSliceFinished(Action1<DateTime> callback) {
        this.finishedTimeSlicesSubscriptions.add(this.finishedTimeSlices.subscribe(timeSlice -> callback.call((Object)new DateTime(timeSlice))));
    }

    public void onJobFinished(Action1<JobDetails> callback) {
        this.jobFinishedSubscriptions.add(this.jobFinished.subscribe(arg_0 -> callback.call(arg_0)));
    }

    public long now() {
        return this.tickScheduler.now();
    }

    public void advanceTimeTo(long timestamp) {
        this.tickScheduler.advanceTimeTo(timestamp, TimeUnit.MILLISECONDS);
    }

    public void advanceTimeBy(int minutes) {
        this.tickScheduler.advanceTimeBy((long)minutes, TimeUnit.MINUTES);
    }
}

