/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.scheduler.impl;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import java.util.Date;
import java.util.UUID;
import org.hawkular.metrics.scheduler.api.JobDetails;
import org.hawkular.metrics.scheduler.api.JobStatus;
import org.hawkular.metrics.scheduler.api.RepeatingTrigger;
import org.hawkular.metrics.scheduler.api.SingleExecutionTrigger;
import org.hawkular.metrics.scheduler.api.Trigger;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.jboss.logging.Logger;
import rx.Observable;
import rx.Scheduler;

public class JobsService {
    private static Logger logger = Logger.getLogger(JobsService.class);
    private RxSession session;
    private PreparedStatement findScheduled;
    private PreparedStatement insertScheduled;
    private PreparedStatement update;
    private PreparedStatement updateStatus;

    public JobsService(RxSession session) {
        this.session = session;
        this.findScheduled = session.getSession().prepare("SELECT job_id, job_type, job_name, job_params, trigger, status FROM scheduled_jobs_idx WHERE time_slice = ?");
        this.update = session.getSession().prepare("INSERT INTO jobs (id, type, name, params, trigger) VALUES (?, ?, ?, ?, ?)");
        this.insertScheduled = session.getSession().prepare("INSERT INTO scheduled_jobs_idx (time_slice, job_id, job_type, job_name, job_params, trigger, status) VALUES (?, ?, ?, ?, ?, ?, ?)");
        this.updateStatus = session.getSession().prepare("UPDATE scheduled_jobs_idx SET status = ? WHERE time_slice = ? AND job_id = ?");
    }

    public Observable<JobDetails> findScheduledJobs(Date timeSlice, Scheduler scheduler) {
        return this.session.executeAndFetch((Statement)this.findScheduled.bind(new Object[]{timeSlice}), scheduler).map(row -> new JobDetails(row.getUUID(0), row.getString(1), row.getString(2), row.getMap(3, String.class, String.class), JobsService.getTrigger(row.getUDTValue(4)), JobStatus.fromCode(row.getByte(5))));
    }

    public Observable<ResultSet> insert(Date timeSlice, JobDetails job) {
        return this.session.execute((Statement)this.insertScheduled.bind(new Object[]{timeSlice, job.getJobId(), job.getJobType(), job.getJobName(), job.getParameters(), JobsService.getTriggerValue(this.session, job.getTrigger())}));
    }

    public Observable<ResultSet> updateStatusToFinished(Date timeSlice, UUID jobId) {
        return this.session.execute((Statement)this.updateStatus.bind(new Object[]{(byte)1, timeSlice, jobId})).doOnError(t -> logger.warn((Object)("There was an error updating the status to finished for [" + jobId + "] in time slice [" + timeSlice.getTime() + "]")));
    }

    static Trigger getTrigger(UDTValue value) {
        int type = value.getInt("type");
        switch (type) {
            case 0: {
                return new SingleExecutionTrigger(value.getLong("trigger_time"));
            }
            case 1: {
                return new RepeatingTrigger(value.getLong("interval"), value.getLong("delay"), value.getLong("trigger_time"), value.getInt("repeat_count"), value.getInt("execution_count"));
            }
        }
        throw new IllegalArgumentException("Trigger type [" + type + "] is not supported");
    }

    static UDTValue getTriggerValue(RxSession session, Trigger trigger) {
        if (trigger instanceof RepeatingTrigger) {
            return JobsService.getRepeatingTriggerValue(session, (RepeatingTrigger)trigger);
        }
        if (trigger instanceof SingleExecutionTrigger) {
            return JobsService.getSingleExecutionTriggerValue(session, (SingleExecutionTrigger)trigger);
        }
        throw new IllegalArgumentException(trigger.getClass() + " is not a supported trigger type");
    }

    static UDTValue getSingleExecutionTriggerValue(RxSession session, SingleExecutionTrigger trigger) {
        UserType triggerType = JobsService.getKeyspace(session).getUserType("trigger_def");
        UDTValue triggerUDT = triggerType.newValue();
        triggerUDT.setInt("type", 0);
        triggerUDT.setLong("trigger_time", trigger.getTriggerTime());
        return triggerUDT;
    }

    static UDTValue getRepeatingTriggerValue(RxSession session, RepeatingTrigger trigger) {
        UserType triggerType = JobsService.getKeyspace(session).getUserType("trigger_def");
        UDTValue triggerUDT = triggerType.newValue();
        triggerUDT.setInt("type", 1);
        triggerUDT.setLong("interval", trigger.getInterval());
        triggerUDT.setLong("trigger_time", trigger.getTriggerTime());
        if (trigger.getDelay() > 0L) {
            triggerUDT.setLong("delay", trigger.getDelay());
        }
        if (trigger.getRepeatCount() != null) {
            triggerUDT.setInt("repeat_count", trigger.getRepeatCount().intValue());
            triggerUDT.setInt("execution_count", trigger.getExecutionCount());
        }
        return triggerUDT;
    }

    private static KeyspaceMetadata getKeyspace(RxSession session) {
        return session.getCluster().getMetadata().getKeyspace(session.getLoggedKeyspace());
    }
}

