/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.scheduler.impl;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.jboss.logging.Logger;
import rx.Observable;
import rx.Scheduler;

class LockManager {
    private static Logger logger = Logger.getLogger(LockManager.class);
    private RxSession session;
    private PreparedStatement acquireLock;
    private PreparedStatement acquireExclusiveLock;
    private PreparedStatement releaseLock;
    private PreparedStatement renewLock;

    public LockManager(RxSession session) {
        this.session = session;
        this.acquireLock = session.getSession().prepare("UPDATE locks USING TTL ? SET value = ? WHERE name = ? IF value IN (NULL, ?)");
        this.acquireExclusiveLock = session.getSession().prepare("UPDATE locks USING TTL? SET value = ? WHERE name = ? IF value = NULL");
        this.releaseLock = session.getSession().prepare("UPDATE locks SET value = NULL WHERE name = ? IF value = ?");
        this.renewLock = session.getSession().prepare("UPDATE locks USING TTL ? SET value = ? WHERE name = ? IF value = ?");
    }

    public Observable<Boolean> acquireSharedLock(String name, String value, int timeout) {
        return this.session.execute((Statement)this.acquireLock.bind(new Object[]{timeout, value, name, value})).map(ResultSet::wasApplied);
    }

    public Observable<Boolean> acquireSharedLock(String name, String value, int timeout, Scheduler scheduler) {
        return this.session.execute((Statement)this.acquireLock.bind(new Object[]{timeout, value, name}), scheduler).map(ResultSet::wasApplied);
    }

    public Observable<Boolean> acquireExclusiveLock(String name, String value, int timeout) {
        return this.session.execute((Statement)this.acquireExclusiveLock.bind(new Object[]{timeout, value, name})).map(ResultSet::wasApplied);
    }

    public Observable<Boolean> releaseLock(String name, String value) {
        logger.debug((Object)("Releasing lock " + name));
        return this.session.execute((Statement)this.releaseLock.bind(new Object[]{name, value})).map(ResultSet::wasApplied);
    }

    public Observable<Boolean> renewLock(String name, String value, int timeout) {
        return this.session.execute((Statement)this.renewLock.bind(new Object[]{timeout, value, name, value})).map(ResultSet::wasApplied);
    }
}

