/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.scheduler.api;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.hawkular.metrics.scheduler.api.JobStatus;
import org.hawkular.metrics.scheduler.api.Trigger;

public class JobDetails {
    private UUID jobId;
    private String jobType;
    private String jobName;
    private Map<String, String> parameters;
    private Trigger trigger;
    private JobStatus status;

    public JobDetails(UUID jobId, String jobType, String jobName, Map<String, String> parameters, Trigger trigger) {
        this.jobId = jobId;
        this.jobType = jobType;
        this.jobName = jobName;
        this.parameters = Collections.unmodifiableMap(parameters);
        this.trigger = trigger;
        this.status = JobStatus.NONE;
    }

    public JobDetails(UUID jobId, String jobType, String jobName, Map<String, String> parameters, Trigger trigger, JobStatus status) {
        this.jobId = jobId;
        this.jobType = jobType;
        this.jobName = jobName;
        this.parameters = Collections.unmodifiableMap(parameters);
        this.trigger = trigger;
        this.status = status;
    }

    public UUID getJobId() {
        return this.jobId;
    }

    public String getJobType() {
        return this.jobType;
    }

    public String getJobName() {
        return this.jobName;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDetails details = (JobDetails)o;
        return Objects.equals(this.jobId, details.jobId) && Objects.equals(this.jobType, details.jobType) && Objects.equals(this.jobName, details.jobName) && Objects.equals(this.parameters, details.parameters) && Objects.equals(this.trigger, details.trigger) && Objects.equals((Object)this.status, (Object)details.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.jobType, this.jobName, this.parameters, this.trigger, this.status});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("jobId", (Object)this.jobId).add("jobType", (Object)this.jobType).add("jobName", (Object)this.jobName).add("parameters", this.parameters).add("trigger", (Object)this.trigger).add("status", (Object)this.status).omitNullValues().toString();
    }
}

