/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.scheduler.impl;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import org.hawkular.metrics.scheduler.api.JobDetails;
import org.hawkular.metrics.scheduler.api.JobParameters;
import org.hawkular.metrics.scheduler.api.JobStatus;
import org.hawkular.metrics.scheduler.api.Trigger;
import org.hawkular.metrics.scheduler.impl.JobParametersImpl;
import rx.Completable;

public class JobDetailsImpl
implements JobDetails {
    private UUID jobId;
    private String jobType;
    private String jobName;
    private JobParametersImpl parameters;
    private Trigger trigger;
    private JobStatus status;

    public JobDetailsImpl(UUID jobId, String jobType, String jobName, JobParametersImpl parameters, Trigger trigger) {
        this.jobId = jobId;
        this.jobType = jobType;
        this.jobName = jobName;
        this.parameters = parameters;
        this.trigger = trigger;
        this.status = JobStatus.NONE;
    }

    public JobDetailsImpl(UUID jobId, String jobType, String jobName, JobParametersImpl parameters, Trigger trigger, JobStatus status) {
        this.jobId = jobId;
        this.jobType = jobType;
        this.jobName = jobName;
        this.parameters = parameters;
        this.trigger = trigger;
        this.status = status;
    }

    public JobDetailsImpl(JobDetailsImpl details, Trigger newTrigger) {
        this.jobId = details.jobId;
        this.jobType = details.jobType;
        this.jobName = details.jobName;
        this.parameters = details.parameters;
        this.status = details.status;
        this.trigger = newTrigger;
    }

    @Override
    public UUID getJobId() {
        return this.jobId;
    }

    @Override
    public String getJobType() {
        return this.jobType;
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public JobParameters getParameters() {
        return this.parameters;
    }

    public void setSaveParameters(Function<Map<String, String>, Completable> saveParameters) {
        this.parameters.setSaveParameters(saveParameters);
    }

    @Override
    public Trigger getTrigger() {
        return this.trigger;
    }

    @Override
    public JobStatus getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDetailsImpl details = (JobDetailsImpl)o;
        return Objects.equals(this.jobId, details.jobId) && Objects.equals(this.jobType, details.jobType) && Objects.equals(this.jobName, details.jobName) && Objects.equals(this.parameters, details.parameters) && Objects.equals(this.trigger, details.trigger) && Objects.equals((Object)this.status, (Object)details.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.jobType, this.jobName, this.parameters, this.trigger, this.status});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("jobId", (Object)this.jobId).add("jobType", (Object)this.jobType).add("jobName", (Object)this.jobName).add("parameters", (Object)this.parameters).add("trigger", (Object)this.trigger).add("status", (Object)this.status).omitNullValues().toString();
    }
}

