/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.scheduler.api;

import com.datastax.driver.core.Session;
import com.google.common.collect.ImmutableMap;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.datetime.DateTimeService;
import org.hawkular.metrics.scheduler.api.JobDetails;
import org.hawkular.metrics.scheduler.api.RepeatingTrigger;
import org.hawkular.metrics.scheduler.api.Scheduler;
import org.hawkular.metrics.scheduler.impl.SchedulerImpl;
import org.hawkular.metrics.sysconfig.Configuration;
import org.hawkular.metrics.sysconfig.ConfigurationService;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.hawkular.rx.cassandra.driver.RxSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Completable;

public class JobsManager {
    private static Logger logger = LoggerFactory.getLogger(JobsManager.class);
    public static final String COMPRESS_DATA_JOB = "COMPRESS_DATA";
    public static final String COMPRESS_DATA_CONFIG_ID = "org.hawkular.metrics.jobs.COMPRESS_DATA";
    public static final String TEMP_TABLE_CREATOR_JOB = "TEMP_TABLE_CREATOR";
    public static final String TEMP_TABLE_CREATE_CONFIG_ID = "org.hawkular.metrics.jobs.TEMP_TABLE_CREATOR";
    public static final String TEMP_DATA_COMPRESSOR_JOB = "TEMP_DATA_COMPRESSOR";
    public static final String TEMP_DATA_COMPRESSOR_CONFIG_ID = "org.hawkular.metrics.jobs.TEMP_DATA_COMPRESSOR";
    public static final String DELETE_EXPIRED_METRICS_JOB = "DELETE_EXPIRED_METRICS";
    public static final String DELETE_EXPIRED_METRICS_CONFIG_ID = "org.hawkular.metrics.jobs.DELETE_EXPIRED_METRICS";
    private ConfigurationService configurationService;
    private Scheduler scheduler;

    public JobsManager(Session session) {
        RxSessionImpl rxSession = new RxSessionImpl(session);
        this.configurationService = new ConfigurationService();
        this.configurationService.init((RxSession)rxSession);
        this.scheduler = new SchedulerImpl((RxSession)rxSession, "localhost");
    }

    public List<JobDetails> installJobs() {
        logger.info("Installing scheduled jobs");
        ArrayList<JobDetails> backgroundJobs = new ArrayList<JobDetails>();
        this.unscheduleCompressData();
        this.maybeScheduleTableCreator(backgroundJobs);
        this.maybeScheduleTempDataCompressor(backgroundJobs);
        this.maybeScheduleMetricExpirationJob(backgroundJobs);
        return backgroundJobs;
    }

    private void unscheduleCompressData() {
        Configuration config = (Configuration)this.configurationService.load(COMPRESS_DATA_JOB).toBlocking().firstOrDefault((Object)new Configuration(COMPRESS_DATA_CONFIG_ID, new HashMap()));
        String jobId = config.get("jobId");
        if (!config.getProperties().isEmpty()) {
            Completable unscheduled;
            if (jobId == null) {
                logger.info("Expected to find a jobId property in database for {}. Attempting to unschedule job by name.", (Object)COMPRESS_DATA_JOB);
                unscheduled = this.scheduler.unscheduleJobByTypeAndName(COMPRESS_DATA_JOB, COMPRESS_DATA_JOB);
            } else {
                unscheduled = this.scheduler.unscheduleJobById(jobId);
            }
            unscheduled.await();
            if (!config.getProperties().isEmpty()) {
                this.configurationService.delete(COMPRESS_DATA_CONFIG_ID).await();
            }
        }
    }

    private void maybeScheduleTableCreator(List<JobDetails> backgroundJobs) {
        Configuration config = (Configuration)this.configurationService.load(TEMP_TABLE_CREATE_CONFIG_ID).toBlocking().firstOrDefault((Object)new Configuration(TEMP_TABLE_CREATE_CONFIG_ID, new HashMap()));
        if (config.get("jobId") == null) {
            long nextTrigger = LocalDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MINUTES).plusMinutes(2L).toInstant(ZoneOffset.UTC).toEpochMilli();
            JobDetails jobDetails = (JobDetails)this.scheduler.scheduleJob(TEMP_TABLE_CREATOR_JOB, TEMP_TABLE_CREATOR_JOB, (Map<String, String>)ImmutableMap.of(), new RepeatingTrigger.Builder().withTriggerTime(nextTrigger).withInterval(2, TimeUnit.HOURS).build()).toBlocking().value();
            backgroundJobs.add(jobDetails);
            this.configurationService.save(TEMP_TABLE_CREATE_CONFIG_ID, "jobId", jobDetails.getJobId().toString()).toBlocking();
            logger.info("Scheduled temporary table creator " + jobDetails);
        }
    }

    private void maybeScheduleTempDataCompressor(List<JobDetails> backgroundJobs) {
        Configuration config = (Configuration)this.configurationService.load(TEMP_DATA_COMPRESSOR_CONFIG_ID).toBlocking().firstOrDefault((Object)new Configuration(TEMP_DATA_COMPRESSOR_CONFIG_ID, new HashMap()));
        if (config.get("jobId") == null) {
            logger.info("Preparing to create and schedule TEMP_DATA_COMPRESSOR job");
            long nextStart = LocalDateTime.now(ZoneOffset.UTC).with(DateTimeService.startOfNextOddHour()).toInstant(ZoneOffset.UTC).toEpochMilli();
            JobDetails jobDetails = (JobDetails)this.scheduler.scheduleJob(TEMP_DATA_COMPRESSOR_JOB, TEMP_DATA_COMPRESSOR_JOB, (Map<String, String>)ImmutableMap.of(), new RepeatingTrigger.Builder().withTriggerTime(nextStart).withInterval(2, TimeUnit.HOURS).build()).toBlocking().value();
            backgroundJobs.add(jobDetails);
            this.configurationService.save(TEMP_DATA_COMPRESSOR_CONFIG_ID, "jobId", jobDetails.getJobId().toString()).toBlocking();
            logger.info("Created and scheduled " + jobDetails);
        }
    }

    private void maybeScheduleMetricExpirationJob(List<JobDetails> backgroundJobs) {
        int metricExpirationJobFrequencyInDays = Integer.getInteger("hawkular.metrics.jobs.expiration.frequency", 7);
        boolean metricExpirationJobEnabled = Boolean.getBoolean("hawkular.metrics.jobs.expiration.enabled");
        String jobIdConfigKey = "jobId";
        String jobFrequencyKey = "jobFrequency";
        Configuration config = (Configuration)this.configurationService.load(DELETE_EXPIRED_METRICS_CONFIG_ID).toBlocking().firstOrDefault((Object)new Configuration(DELETE_EXPIRED_METRICS_CONFIG_ID, new HashMap()));
        if (config.get(jobIdConfigKey) != null) {
            Integer configuredJobFrequency = null;
            try {
                configuredJobFrequency = Integer.parseInt(config.get(jobFrequencyKey));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (configuredJobFrequency == null || configuredJobFrequency != metricExpirationJobFrequencyInDays || metricExpirationJobFrequencyInDays <= 0 || configuredJobFrequency <= 0 || !metricExpirationJobEnabled) {
                this.scheduler.unscheduleJobById(config.get(jobIdConfigKey)).await();
                this.configurationService.delete(DELETE_EXPIRED_METRICS_CONFIG_ID, jobIdConfigKey).concatWith(this.configurationService.delete(DELETE_EXPIRED_METRICS_CONFIG_ID, jobFrequencyKey)).await();
                config.delete(jobIdConfigKey);
                config.delete(jobFrequencyKey);
            }
        }
        if (config.get(jobIdConfigKey) == null && metricExpirationJobFrequencyInDays > 0 && metricExpirationJobEnabled) {
            logger.info("Preparing to create and schedule DELETE_EXPIRED_METRICS job");
            long nextStart = DateTimeService.current24HourTimeSlice().plusDays(1).getMillis();
            JobDetails jobDetails = (JobDetails)this.scheduler.scheduleJob(DELETE_EXPIRED_METRICS_JOB, DELETE_EXPIRED_METRICS_JOB, (Map<String, String>)ImmutableMap.of(), new RepeatingTrigger.Builder().withTriggerTime(nextStart).withInterval(metricExpirationJobFrequencyInDays, TimeUnit.DAYS).build()).toBlocking().value();
            backgroundJobs.add(jobDetails);
            this.configurationService.save(DELETE_EXPIRED_METRICS_CONFIG_ID, jobIdConfigKey, jobDetails.getJobId().toString()).toBlocking();
            this.configurationService.save(DELETE_EXPIRED_METRICS_CONFIG_ID, jobFrequencyKey, metricExpirationJobFrequencyInDays + "").toBlocking();
            logger.info("Created and scheduled " + jobDetails);
        }
    }
}

