/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.openshift.auth;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.Md5Crypt;

public class BasicAuthentication {
    static final String BASIC_PREFIX = "Basic ";
    private static final String HTPASSWD_FILE = System.getProperty("hawkular-metrics.openshift.htpasswd-file", "~/.htpasswd");
    public static final String MD5_PREFIX = "$apr1$";
    public static final String SHA_PREFIX = "{SHA}";
    private Map<String, String> users = new HashMap<String, String>();

    public BasicAuthentication() throws IOException {
        File passwdFile = new File(HTPASSWD_FILE);
        if (passwdFile.exists() && passwdFile.isFile()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(passwdFile));){
                String line = reader.readLine();
                while (line != null) {
                    String[] values = line.split(":", 2);
                    if (values.length == 2) {
                        this.users.put(values[0], values[1]);
                    }
                    line = reader.readLine();
                }
            }
        }
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.users == null || this.users.isEmpty()) {
            response.sendError(403);
            return;
        }
        String basicHeader = request.getHeader("authorization");
        if (basicHeader != null && basicHeader.startsWith(BASIC_PREFIX)) {
            basicHeader = basicHeader.substring(BASIC_PREFIX.length());
            String usernamePassword = new String(Base64.getDecoder().decode(basicHeader));
            String[] entries = usernamePassword.split(":", 2);
            if (entries.length == 2) {
                String username = entries[0];
                String password = entries[1];
                if (username != null && password != null && this.users.containsKey(username) && this.isAuthorized(username, password)) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
            }
        }
        response.sendError(403);
    }

    private boolean isAuthorized(String username, String password) {
        String storedPassword = this.users.get(username);
        if (storedPassword != null && storedPassword.startsWith(MD5_PREFIX)) {
            return this.verifyMD5Password(storedPassword, password);
        }
        if (storedPassword != null && storedPassword.startsWith(SHA_PREFIX)) {
            return this.verifySHA1Password(storedPassword, password);
        }
        return false;
    }

    private boolean verifyMD5Password(String storedPassword, String passedPassword) {
        String encryptedPassword = Md5Crypt.apr1Crypt((String)passedPassword, (String)storedPassword);
        return encryptedPassword.equals(storedPassword);
    }

    private boolean verifySHA1Password(String storedPassword, String passedPassword) {
        storedPassword = storedPassword.substring(SHA_PREFIX.length());
        byte[] digestedPasswordBytes = DigestUtils.sha1((String)passedPassword);
        String digestedPassword = Base64.getEncoder().encodeToString(digestedPasswordBytes);
        return digestedPassword.equals(storedPassword);
    }
}

