/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.openshift.auth;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hawkular.openshift.auth.BasicAuthentication;
import org.hawkular.openshift.auth.OpenShiftTokenAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftAuthenticationFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(OpenShiftAuthenticationFilter.class);
    public static final String AUTHORIZATION_HEADER = "authorization";
    private static final String OPENSHIFT_OAUTH = "openshift-oauth";
    private static final String HTPASSWD = "htpasswd";
    private static final String DISABLED = "disabled";
    private static final String SECURITY_OPTION = System.getProperty("hawkular-metrics.openshift.auth-methods", "openshift-oauth");
    private BasicAuthentication basicAuthentication;

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            if (SECURITY_OPTION.contains(HTPASSWD)) {
                this.basicAuthentication = new BasicAuthentication();
            }
        }
        catch (IOException e) {
            logger.error("Error trying to setup BasicAuthentication based on an htpasswd file.", (Throwable)e);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (SECURITY_OPTION.equalsIgnoreCase(DISABLED)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (request.getMethod().equalsIgnoreCase("Options") && request.getHeader("Origin") != null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String servletPath = request.getServletPath();
        String path = request.getPathInfo();
        if (path == null || path.equals("") || path.equals("/") || path.equals("/status") || servletPath.equals("/static")) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String authorizationHeader = request.getHeader(AUTHORIZATION_HEADER);
        if (authorizationHeader == null) {
            response.sendError(403);
            return;
        }
        if (authorizationHeader.startsWith("Bearer ") && SECURITY_OPTION.contains(OPENSHIFT_OAUTH)) {
            OpenShiftTokenAuthentication tokenAuthentication = new OpenShiftTokenAuthentication();
            tokenAuthentication.doFilter(request, response, filterChain);
            return;
        }
        if (authorizationHeader.startsWith("Basic ") && SECURITY_OPTION.contains(HTPASSWD) && this.basicAuthentication != null) {
            this.basicAuthentication.doFilter(request, response, filterChain);
            return;
        }
        response.sendError(403);
    }

    public void destroy() {
    }
}

