/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.openshift.auth;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.Uninterruptibles;
import io.undertow.Undertow;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.UndertowClient;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.XnioByteBufferPool;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.StringReadChannelListener;
import io.undertow.util.StringWriteChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.UnresolvedAddressException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.hawkular.metrics.api.jaxrs.util.MetricRegistryProvider;
import org.hawkular.openshift.auth.Authenticator;
import org.hawkular.openshift.auth.Utils;
import org.jboss.logging.Logger;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Xnio;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.ssl.XnioSsl;

class TokenAuthenticator
implements Authenticator {
    private static final Logger log = Logger.getLogger(TokenAuthenticator.class);
    private static final AttachmentKey<AuthContext> AUTH_CONTEXT_KEY = AttachmentKey.create(AuthContext.class);
    private static final HttpString HAWKULAR_TENANT = new HttpString("Hawkular-Tenant");
    static final String BEARER_PREFIX = "Bearer ";
    private static final String MISSING_HEADERS_MSG = "The '" + Headers.AUTHORIZATION + "' and '" + HAWKULAR_TENANT + "' headers are required";
    private static final String UNAUTHORIZED_USER_EDIT_MSG = "Users are not authorized to perform edits on metric data";
    private static final String RESOURCE = "pods";
    private static final String KIND = "SubjectAccessReview";
    private static final Map<HttpString, String> VERBS;
    private static final String VERBS_DEFAULT;
    private static final String KUBERNETES_MASTER_URL_SYSPROP = "KUBERNETES_MASTER_URL";
    private static final String USER_WRITE_ACCESS_SYSPROP = "USER_WRITE_ACCESS";
    private static final String KUBERNETES_MASTER_URL_DEFAULT = "https://kubernetes.default.svc.cluster.local";
    private static final String KUBERNETES_MASTER_URL;
    private static final String USER_WRITE_ACCESS;
    private static final String ACCESS_URI = "/oapi/v1/subjectaccessreviews";
    private static final int MAX_CONNECTIONS_PER_THREAD = 20;
    private static final long CONNECTION_WAIT_TIMEOUT;
    private static final String TIMEDOUT_WAITING_CONNECTION = "Could not acquire a Kubernetes client connection";
    private static final long CONNECTION_TTL;
    private static final int MAX_RETRY = 5;
    private static final int MAX_PENDING = 32768;
    private static final String TOO_MANY_PENDING_REQUESTS = "Too many pending requests";
    private static final String CLIENT_REQUEST_FAILURE = "Kubernetes client request failure";
    private final HttpHandler containerHandler;
    private final ObjectMapper objectMapper;
    private final URI kubernetesMasterUri;
    private final ConcurrentMap<XnioIoThread, ConnectionPool> connectionPools;
    private final ConnectionFactory connectionFactory;
    private final Timer authLatency;
    private final Timer apiLatency;

    TokenAuthenticator(HttpHandler containerHandler) {
        this.containerHandler = containerHandler;
        this.objectMapper = new ObjectMapper();
        try {
            this.kubernetesMasterUri = new URI(KUBERNETES_MASTER_URL);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.connectionPools = new ConcurrentHashMap<XnioIoThread, ConnectionPool>(Runtime.getRuntime().availableProcessors(), 1.0f);
        this.connectionFactory = new ConnectionFactory(this.kubernetesMasterUri);
        MetricRegistry metrics = MetricRegistryProvider.INSTANCE.getMetricRegistry();
        this.authLatency = metrics.timer("openshift-oauth-latency");
        this.apiLatency = metrics.timer("openshift-oauth-kubernetes-response-time");
    }

    public void handleRequest(HttpServerExchange serverExchange) throws Exception {
        AuthContext context = AuthContext.initialize(serverExchange);
        serverExchange.putAttachment(AUTH_CONTEXT_KEY, (Object)context);
        serverExchange.addExchangeCompleteListener((exchange, nextListener) -> {
            exchange.removeAttachment(AUTH_CONTEXT_KEY);
            nextListener.proceed();
        });
        if (context.isMissingTenantHeader()) {
            Utils.endExchange(serverExchange, 400, MISSING_HEADERS_MSG);
            return;
        }
        if (!USER_WRITE_ACCESS.equalsIgnoreCase("true") && !this.isQuery(serverExchange)) {
            Utils.endExchange(serverExchange, 401, UNAUTHORIZED_USER_EDIT_MSG);
            return;
        }
        serverExchange.dispatch();
        XnioIoThread ioThread = serverExchange.getIoThread();
        ConnectionPool connectionPool = this.connectionPools.computeIfAbsent(ioThread, t -> new ConnectionPool(this.connectionFactory));
        PooledConnectionWaiter waiter = this.createWaiter(serverExchange);
        if (!connectionPool.offer(waiter)) {
            Utils.endExchange(serverExchange, 500, TOO_MANY_PENDING_REQUESTS);
        }
    }

    private boolean isQuery(HttpServerExchange serverExchange) {
        if (serverExchange.getRequestMethod().toString().equalsIgnoreCase("GET") || serverExchange.getRequestMethod().toString().equalsIgnoreCase("HEAD")) {
            return true;
        }
        if (serverExchange.getRequestMethod().toString().equalsIgnoreCase("POST")) {
            String[] paths = serverExchange.getRelativePath().split("/");
            return paths.length >= 4 && (paths[2].equals("raw") || paths[2].equals("stats")) && paths[3].equals("query");
        }
        return false;
    }

    private PooledConnectionWaiter createWaiter(HttpServerExchange serverExchange) {
        Consumer<PooledConnection> onGet = connection -> this.sendAuthenticationRequest(serverExchange, (PooledConnection)connection);
        Runnable onTimeout = () -> this.onPooledConnectionWaitTimeout(serverExchange);
        return new PooledConnectionWaiter(onGet, onTimeout);
    }

    private void sendAuthenticationRequest(HttpServerExchange serverExchange, PooledConnection connection) {
        AuthContext context = (AuthContext)serverExchange.getAttachment(AUTH_CONTEXT_KEY);
        String verb = this.getVerb(serverExchange);
        context.subjectAccessReview = this.generateSubjectAccessReview(context.tenant, verb);
        ClientRequest request = this.buildClientRequest(context);
        context.clientRequestStarting();
        connection.sendRequest(request, (ClientCallback<ClientExchange>)new RequestReadyCallback(serverExchange, connection));
    }

    private void onPooledConnectionWaitTimeout(HttpServerExchange serverExchange) {
        Utils.endExchange(serverExchange, 500, TIMEDOUT_WAITING_CONNECTION);
    }

    private String getVerb(HttpServerExchange serverExchange) {
        if (this.isQuery(serverExchange)) {
            return VERBS.get(Methods.GET);
        }
        String verb = VERBS.get(serverExchange.getRequestMethod());
        if (verb == null) {
            log.debugf("Unhandled http method '%s'. Checking for read access.", (Object)serverExchange.getRequestMethod());
            verb = VERBS_DEFAULT;
        }
        return verb;
    }

    private String generateSubjectAccessReview(String namespace, String verb) {
        ObjectNode objectNode = this.objectMapper.createObjectNode();
        objectNode.put("apiVersion", "v1");
        objectNode.put("kind", KIND);
        objectNode.put("resource", RESOURCE);
        objectNode.put("verb", verb);
        objectNode.put("namespace", namespace);
        return objectNode.toString();
    }

    private ClientRequest buildClientRequest(AuthContext context) {
        ClientRequest request = new ClientRequest().setMethod(Methods.POST).setPath(ACCESS_URI);
        String host = this.kubernetesMasterUri.getHost();
        int port = this.kubernetesMasterUri.getPort();
        String hostHeader = port == -1 ? host : host + ":" + port;
        request.getRequestHeaders().add(Headers.HOST, hostHeader).add(Headers.ACCEPT, "application/json").add(Headers.CONTENT_TYPE, "application/json").add(Headers.AUTHORIZATION, context.authorizationHeader).add(Headers.CONTENT_LENGTH, (long)context.subjectAccessReview.length());
        return request;
    }

    private void onRequestResult(HttpServerExchange serverExchange, PooledConnection connection, boolean allowed) {
        ((ConnectionPool)this.connectionPools.get(serverExchange.getIoThread())).release(connection);
        AuthContext context = (AuthContext)serverExchange.removeAttachment(AUTH_CONTEXT_KEY);
        this.apiLatency.update(context.getClientResponseTime(), TimeUnit.NANOSECONDS);
        this.authLatency.update(context.getLatency(), TimeUnit.NANOSECONDS);
        if (allowed) {
            serverExchange.dispatch(this.containerHandler);
        } else {
            Utils.endExchange(serverExchange, 403);
        }
    }

    private void onRequestFailure(HttpServerExchange serverExchange, PooledConnection connection, IOException e) {
        log.debug((Object)"Client request failure", (Throwable)e);
        IoUtils.safeClose((Closeable)connection);
        ConnectionPool connectionPool = (ConnectionPool)this.connectionPools.get(serverExchange.getIoThread());
        connectionPool.release(connection);
        AuthContext context = (AuthContext)serverExchange.getAttachment(AUTH_CONTEXT_KEY);
        if (context.retries < 5) {
            context.retries++;
            PooledConnectionWaiter waiter = this.createWaiter(serverExchange);
            if (!connectionPool.offer(waiter)) {
                Utils.endExchange(serverExchange, 500, TOO_MANY_PENDING_REQUESTS);
            }
        } else {
            Utils.endExchange(serverExchange, 500, CLIENT_REQUEST_FAILURE);
        }
    }

    @Override
    public void stop() {
        Set entries = this.connectionPools.entrySet();
        CountDownLatch latch = new CountDownLatch(entries.size());
        entries.forEach(entry -> ((XnioIoThread)entry.getKey()).execute(() -> ((ConnectionPool)entry.getValue()).stop(latch::countDown)));
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        this.connectionFactory.close();
    }

    static {
        HashMap<HttpString, String> verbs = new HashMap<HttpString, String>();
        verbs.put(Methods.GET, "list");
        verbs.put(Methods.PUT, "update");
        verbs.put(Methods.POST, "update");
        verbs.put(Methods.DELETE, "update");
        verbs.put(new HttpString("PATCH"), "update");
        VERBS = Collections.unmodifiableMap(verbs);
        VERBS_DEFAULT = VERBS.get(Methods.GET);
        KUBERNETES_MASTER_URL = System.getProperty(KUBERNETES_MASTER_URL_SYSPROP, KUBERNETES_MASTER_URL_DEFAULT);
        USER_WRITE_ACCESS = System.getProperty(USER_WRITE_ACCESS_SYSPROP, "false");
        CONNECTION_WAIT_TIMEOUT = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
        CONNECTION_TTL = TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS);
    }

    private static class ConnectionFactory {
        private final URI kubernetesMasterUri;
        private final UndertowClient undertowClient;
        private final XnioSsl ssl;
        private final ByteBufferPool byteBufferPool;

        private ConnectionFactory(URI kubernetesMasterUri) {
            this.kubernetesMasterUri = kubernetesMasterUri;
            this.undertowClient = UndertowClient.getInstance();
            Xnio xnio = Xnio.getInstance((ClassLoader)Undertow.class.getClassLoader());
            try {
                this.ssl = new UndertowXnioSsl(xnio, OptionMap.EMPTY);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.byteBufferPool = this.createByteBufferPool();
        }

        private ByteBufferPool createByteBufferPool() {
            int buffersPerRegion;
            int bufferSize;
            boolean useDirectBuffers;
            long maxMemory = Runtime.getRuntime().maxMemory();
            if (maxMemory < 0x4000000L) {
                useDirectBuffers = false;
                bufferSize = 512;
                buffersPerRegion = 10;
            } else if (maxMemory < 0x8000000L) {
                useDirectBuffers = true;
                bufferSize = 1024;
                buffersPerRegion = 10;
            } else {
                useDirectBuffers = true;
                bufferSize = 16384;
                buffersPerRegion = 20;
            }
            BufferAllocator allocator = useDirectBuffers ? BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR : BufferAllocator.BYTE_BUFFER_ALLOCATOR;
            int maxRegionSize = buffersPerRegion * bufferSize;
            ByteBufferSlicePool pool = new ByteBufferSlicePool(allocator, bufferSize, maxRegionSize);
            return new XnioByteBufferPool((Pool)pool);
        }

        private void createConnection(ClientCallback<ClientConnection> callback) {
            XnioIoThread ioThread = (XnioIoThread)Thread.currentThread();
            this.undertowClient.connect(callback, this.kubernetesMasterUri, ioThread, this.ssl, this.byteBufferPool, OptionMap.EMPTY);
        }

        private void close() {
            this.byteBufferPool.close();
        }
    }

    private static class PooledConnectionWaiter {
        private final Consumer<PooledConnection> onGet;
        private final Runnable onTimeout;
        private final long timestamp;

        private PooledConnectionWaiter(Consumer<PooledConnection> onGet, Runnable onTimeout) {
            this.onGet = onGet;
            this.onTimeout = onTimeout;
            this.timestamp = System.currentTimeMillis();
        }
    }

    private static class PooledConnection
    implements Closeable {
        private ClientConnection clientConnection;
        private boolean idle;
        private long createdOn = System.currentTimeMillis();

        private PooledConnection() {
        }

        private void sendRequest(ClientRequest request, ClientCallback<ClientExchange> clientCallback) {
            this.clientConnection.sendRequest(request, clientCallback);
        }

        private boolean isOpen() {
            return this.clientConnection.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.clientConnection.close();
        }

        private boolean hasExpired(long now) {
            return this.createdOn + CONNECTION_TTL < now;
        }

        private boolean canReuse(long now) {
            return this.isOpen() && !this.hasExpired(now);
        }
    }

    private static class ConnectionPool {
        private final ConnectionFactory connectionFactory;
        private final List<PooledConnection> connections;
        private final Queue<PooledConnectionWaiter> waiters;
        private final XnioExecutor.Key periodicTaskKey;
        private int ongoingCreations;
        private boolean stop;
        private volatile int connectionCount;
        private volatile int waiterCount;

        private ConnectionPool(ConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
            this.connections = new ArrayList<PooledConnection>(20);
            this.waiters = new ArrayDeque<PooledConnectionWaiter>();
            XnioIoThread ioThread = (XnioIoThread)Thread.currentThread();
            this.periodicTaskKey = ioThread.executeAtInterval(this::periodicTask, 1L, TimeUnit.SECONDS);
            MetricRegistry metrics = MetricRegistryProvider.INSTANCE.getMetricRegistry();
            Gauge connectionsGauge = () -> this.connectionCount;
            metrics.register("openshift-oauth-" + ioThread.getName() + "-pool-connections", (Metric)connectionsGauge);
            Gauge waitersGauge = () -> this.waiterCount;
            metrics.register("openshift-oauth-" + ioThread.getName() + "-pool-waiters", (Metric)waitersGauge);
            this.ongoingCreations = 0;
            this.stop = false;
        }

        private void periodicTask() {
            if (this.stop) {
                return;
            }
            long now = System.currentTimeMillis();
            Iterator<PooledConnection> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                PooledConnection connection = iterator.next();
                if (!connection.idle || connection.canReuse(now)) continue;
                iterator.remove();
                IoUtils.safeClose((Closeable)connection);
            }
            this.removeTimedOutWaiters();
            if (!this.waiters.isEmpty() && !this.isFull()) {
                this.createConnection();
            }
            this.connectionCount = this.connections.size();
            this.waiterCount = this.waiters.size();
        }

        private boolean offer(PooledConnectionWaiter waiter) {
            if (this.stop) {
                waiter.onTimeout.run();
                return true;
            }
            this.removeTimedOutWaiters();
            if (this.waiters.size() >= 32768) {
                return false;
            }
            this.waiters.offer(waiter);
            PooledConnection selected = this.selectIdleConnection();
            if (selected != null) {
                this.waiters.poll().onGet.accept(selected);
            }
            return true;
        }

        private PooledConnection selectIdleConnection() {
            long now = System.currentTimeMillis();
            Iterator<PooledConnection> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                PooledConnection connection = iterator.next();
                if (!connection.idle) continue;
                if (connection.canReuse(now)) {
                    connection.idle = false;
                    return connection;
                }
                iterator.remove();
                IoUtils.safeClose((Closeable)connection);
            }
            return null;
        }

        private void release(PooledConnection connection) {
            connection.idle = true;
            if (this.stop) {
                return;
            }
            if (!connection.canReuse(System.currentTimeMillis())) {
                this.connections.remove(connection);
                IoUtils.safeClose((Closeable)connection);
            }
            this.removeTimedOutWaiters();
            if (!this.waiters.isEmpty()) {
                PooledConnection selected = this.selectIdleConnection();
                if (selected != null) {
                    PooledConnectionWaiter waiter = this.waiters.poll();
                    waiter.onGet.accept(selected);
                } else if (!this.isFull()) {
                    this.createConnection();
                }
            }
        }

        private void removeTimedOutWaiters() {
            PooledConnectionWaiter waiter;
            long now = System.currentTimeMillis();
            Iterator iterator = this.waiters.iterator();
            while (iterator.hasNext() && (waiter = (PooledConnectionWaiter)iterator.next()).timestamp + CONNECTION_WAIT_TIMEOUT < now) {
                iterator.remove();
                waiter.onTimeout.run();
            }
        }

        private boolean isFull() {
            return this.connections.size() + this.ongoingCreations == 20;
        }

        private void createConnection() {
            ++this.ongoingCreations;
            try {
                this.connectionFactory.createConnection((ClientCallback<ClientConnection>)((ClientCallback)new ClientCallback<ClientConnection>(){

                    public void completed(ClientConnection result) {
                        ongoingCreations--;
                        this.onConnectionCreated(result);
                    }

                    public void failed(IOException e) {
                        ongoingCreations--;
                        this.onConnectionCreationFailure(e);
                    }
                }));
            }
            catch (UnresolvedAddressException e) {
                --this.ongoingCreations;
                this.onConnectionCreationFailure(e);
            }
        }

        private void onConnectionCreated(ClientConnection clientConnection) {
            if (this.stop) {
                IoUtils.safeClose((Closeable)clientConnection);
                return;
            }
            PooledConnection connection = new PooledConnection();
            connection.clientConnection = clientConnection;
            this.connections.add(connection);
            this.removeTimedOutWaiters();
            if (!this.waiters.isEmpty()) {
                PooledConnectionWaiter waiter = this.waiters.poll();
                connection.idle = false;
                waiter.onGet.accept(connection);
            } else {
                connection.idle = true;
            }
        }

        private void onConnectionCreationFailure(Exception e) {
            log.debug((Object)"Failed to create client connection", (Throwable)e);
            if (this.stop) {
                return;
            }
            XnioIoThread ioThread = (XnioIoThread)Thread.currentThread();
            ioThread.executeAfter(() -> {
                this.removeTimedOutWaiters();
                if (!(this.stop || this.waiters.isEmpty() || this.isFull())) {
                    this.createConnection();
                }
            }, 1L, TimeUnit.SECONDS);
        }

        private void stop(Runnable onStop) {
            this.stop = true;
            this.periodicTaskKey.remove();
            while (!this.waiters.isEmpty()) {
                PooledConnectionWaiter waiter = this.waiters.poll();
                waiter.onTimeout.run();
            }
            this.closeAllConnections(onStop);
        }

        private void closeAllConnections(Runnable onAllClosed) {
            Iterator<PooledConnection> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                PooledConnection connection = iterator.next();
                if (!connection.idle) continue;
                iterator.remove();
                IoUtils.safeClose((Closeable)connection);
            }
            if (this.connections.isEmpty()) {
                onAllClosed.run();
            } else {
                XnioIoThread ioThread = (XnioIoThread)Thread.currentThread();
                ioThread.executeAfter(() -> this.closeAllConnections(onAllClosed), 500L, TimeUnit.MILLISECONDS);
            }
        }
    }

    private class ResponseBodyListener
    extends StringReadChannelListener {
        private final HttpServerExchange serverExchange;
        private final PooledConnection connection;
        private final ClientExchange clientExchange;

        private ResponseBodyListener(HttpServerExchange serverExchange, PooledConnection connection, ClientExchange clientExchange) {
            super(clientExchange.getConnection().getBufferPool());
            this.serverExchange = serverExchange;
            this.connection = connection;
            this.clientExchange = clientExchange;
        }

        protected void stringDone(String body) {
            AuthContext context = (AuthContext)this.serverExchange.getAttachment(AUTH_CONTEXT_KEY);
            context.clientResponseReceived();
            if (this.clientExchange.getResponse().getResponseCode() == 201) {
                try {
                    JsonNode jsonNode = TokenAuthenticator.this.objectMapper.readTree(body);
                    JsonNode allowedNode = jsonNode == null ? null : jsonNode.get("allowed");
                    boolean allowed = allowedNode != null && allowedNode.asBoolean();
                    TokenAuthenticator.this.onRequestResult(this.serverExchange, this.connection, allowed);
                }
                catch (IOException e) {
                    TokenAuthenticator.this.onRequestFailure(this.serverExchange, this.connection, e);
                }
            }
        }

        protected void error(IOException e) {
            TokenAuthenticator.this.onRequestFailure(this.serverExchange, this.connection, e);
        }
    }

    private class ResponseListener
    implements ClientCallback<ClientExchange> {
        private final HttpServerExchange serverExchange;
        private final PooledConnection connection;

        private ResponseListener(HttpServerExchange serverExchange, PooledConnection connection) {
            this.serverExchange = serverExchange;
            this.connection = connection;
        }

        public void completed(ClientExchange clientExchange) {
            ResponseBodyListener readChannelListener = new ResponseBodyListener(this.serverExchange, this.connection, clientExchange);
            readChannelListener.setup(clientExchange.getResponseChannel());
        }

        public void failed(IOException e) {
            TokenAuthenticator.this.onRequestFailure(this.serverExchange, this.connection, e);
        }
    }

    private class RequestReadyCallback
    implements ClientCallback<ClientExchange> {
        private final HttpServerExchange serverExchange;
        private final PooledConnection connection;

        private RequestReadyCallback(HttpServerExchange serverExchange, PooledConnection connection) {
            this.serverExchange = serverExchange;
            this.connection = connection;
        }

        public void completed(ClientExchange clientExchange) {
            clientExchange.setResponseListener((ClientCallback)new ResponseListener(this.serverExchange, this.connection));
            this.writeBody(clientExchange);
        }

        private void writeBody(ClientExchange clientExchange) {
            AuthContext context = (AuthContext)this.serverExchange.getAttachment(AUTH_CONTEXT_KEY);
            StringWriteChannelListener writeChannelListener = new StringWriteChannelListener(context.subjectAccessReview);
            writeChannelListener.setup(clientExchange.getRequestChannel());
        }

        public void failed(IOException e) {
            TokenAuthenticator.this.onRequestFailure(this.serverExchange, this.connection, e);
        }
    }

    private static final class AuthContext {
        private long creation;
        private String authorizationHeader;
        private String tenant;
        private String subjectAccessReview;
        private int retries;
        private long requestStart;
        private long requestStop;

        private AuthContext() {
        }

        private static AuthContext initialize(HttpServerExchange serverExchange) {
            AuthContext context = new AuthContext();
            context.creation = System.nanoTime();
            context.authorizationHeader = serverExchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
            context.tenant = serverExchange.getRequestHeaders().getFirst(HAWKULAR_TENANT);
            return context;
        }

        private boolean isMissingTenantHeader() {
            return this.tenant == null;
        }

        private void clientRequestStarting() {
            this.requestStart = System.nanoTime();
        }

        private void clientResponseReceived() {
            this.requestStop = System.nanoTime();
        }

        private long getClientResponseTime() {
            return this.requestStop - this.requestStart;
        }

        private long getLatency() {
            return this.requestStop - this.creation;
        }
    }
}

