/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.openshift.auth;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.Md5Crypt;
import org.hawkular.openshift.auth.Authenticator;
import org.hawkular.openshift.auth.Utils;
import org.jboss.logging.Logger;

class BasicAuthenticator
implements Authenticator {
    private static final Logger log = Logger.getLogger(BasicAuthenticator.class);
    static final String BASIC_PREFIX = "Basic ";
    private static final String HTPASSWD_FILE_SYSPROP = "hawkular-metrics.openshift.htpasswd-file";
    private static final File HTPASSWD_FILE;
    private static final String MD5_PREFIX = "$apr1$";
    private static final String SHA_PREFIX = "{SHA}";
    private final HttpHandler containerHandler;
    private final Map<String, String> users;

    BasicAuthenticator(HttpHandler containerHandler) {
        this.containerHandler = containerHandler;
        this.users = HTPASSWD_FILE.canRead() ? Collections.unmodifiableMap(this.readHtpasswdFile()) : Collections.emptyMap();
    }

    private Map<String, String> readHtpasswdFile() {
        HashMap<String, String> result = new HashMap<String, String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(HTPASSWD_FILE));){
            reader.lines().forEach(line -> {
                String[] values = line.split(":", 2);
                if (values.length == 2) {
                    result.put(values[0], values[1]);
                }
            });
        }
        catch (Exception e) {
            log.error((Object)"Error trying to setup BasicAuthentication based on an htpasswd file.", (Throwable)e);
        }
        return result;
    }

    public void handleRequest(HttpServerExchange serverExchange) throws Exception {
        if (this.users.isEmpty()) {
            Utils.endExchange(serverExchange, 403);
            return;
        }
        String authorizationHeader = serverExchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
        String usernamePasswordEncoded = authorizationHeader.substring(BASIC_PREFIX.length());
        String usernamePassword = new String(Base64.getDecoder().decode(usernamePasswordEncoded));
        String[] entries = usernamePassword.split(":", 2);
        if (entries.length != 2) {
            Utils.endExchange(serverExchange, 403);
            return;
        }
        String username = entries[0];
        String password = entries[1];
        if (this.users.containsKey(username) && this.isAuthorized(username, password)) {
            this.containerHandler.handleRequest(serverExchange);
        } else {
            Utils.endExchange(serverExchange, 403);
        }
    }

    private boolean isAuthorized(String username, String password) {
        String storedPassword = this.users.get(username);
        return storedPassword.startsWith(MD5_PREFIX) && this.verifyMD5Password(storedPassword, password) || storedPassword.startsWith(SHA_PREFIX) && this.verifySHA1Password(storedPassword, password);
    }

    private boolean verifyMD5Password(String storedPassword, String passedPassword) {
        return Md5Crypt.apr1Crypt((String)passedPassword, (String)storedPassword).equals(storedPassword);
    }

    private boolean verifySHA1Password(String storedPassword, String passedPassword) {
        storedPassword = storedPassword.substring(SHA_PREFIX.length());
        byte[] digestedPasswordBytes = DigestUtils.sha1((String)passedPassword);
        String digestedPassword = Base64.getEncoder().encodeToString(digestedPasswordBytes);
        return digestedPassword.equals(storedPassword);
    }

    @Override
    public void stop() {
    }

    static {
        String htpasswdPath = System.getProperty(HTPASSWD_FILE_SYSPROP);
        HTPASSWD_FILE = htpasswdPath == null ? new File(System.getProperty("user.home"), ".htpasswd") : new File(htpasswdPath);
    }
}

