/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.openshift.auth;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftTokenAuthentication {
    private static final Logger logger = LoggerFactory.getLogger(OpenShiftTokenAuthentication.class);
    private static final String HAWKULAR_TENANT = "hawkular-tenant";
    private static final String KUBERNETES_MASTER_URL = System.getProperty("KUBERNETES_MASTER_URL", "https://kubernetes.default.svc.cluster.local");
    private static final String RESOURCE = "pods";
    private static final String KIND = "SubjectAccessReview";

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String token = request.getHeader("authorization");
        String tenant = request.getHeader(HAWKULAR_TENANT);
        if (token == null || tenant == null) {
            response.sendError(400, "The 'authorization' and 'hawkular-tenant' headers are required");
        } else if (this.isAuthorized(request.getMethod(), token, tenant)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            response.sendError(403);
        }
    }

    private boolean isAuthorized(String method, String token, String projectId) {
        block18: {
            try {
                String verb = this.getVerb(method);
                String path = "/oapi/v1/subjectaccessreviews";
                URL url = new URL(KUBERNETES_MASTER_URL + path);
                HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setRequestProperty("Accept", "application/json");
                connection.setRequestProperty("Authorization", token);
                try (OutputStream outputStream = connection.getOutputStream();){
                    for (byte b : this.generateSubjectAccessReview(projectId, verb).getBytes()) {
                        outputStream.write(b);
                    }
                }
                connection.connect();
                int responseCode = connection.getResponseCode();
                if (responseCode == 201) {
                    ObjectMapper objectMapper = new ObjectMapper();
                    JsonNode jsonNode = objectMapper.readTree(connection.getInputStream());
                    if (jsonNode.get("allowed").asText().equals("true")) {
                        return true;
                    }
                    break block18;
                }
                return false;
            }
            catch (IOException e) {
                logger.error("Error trying to authenticate against the OpenShift server", (Throwable)e);
            }
        }
        return false;
    }

    private String generateSubjectAccessReview(String namespace, String verb) throws IOException {
        ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
        objectNode.put("kind", KIND);
        objectNode.put("resource", RESOURCE);
        objectNode.put("verb", verb);
        objectNode.put("namespace", namespace);
        return objectNode.toString();
    }

    private String getVerb(String method) {
        HTTP_METHOD httpMethod = HTTP_METHOD.valueOf(method);
        switch (httpMethod) {
            case GET: {
                return "list";
            }
            case PUT: {
                return "update";
            }
            case POST: {
                return "update";
            }
            case DELETE: {
                return "delete";
            }
            case PATCH: {
                return "update";
            }
        }
        return null;
    }

    private static enum HTTP_METHOD {
        GET,
        PUT,
        POST,
        DELETE,
        PATCH;

    }
}

