/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.test;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.hawkular.metrics.test.RESTTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ErrorsITest
extends RESTTest {
    Response response = null;

    @After
    public void closeResponse() {
        if (this.response != null) {
            this.response.close();
            this.response = null;
        }
    }

    @Test
    public void testNotAllowedException() {
        this.response = target.clone().path("/gauges/test/tags").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Hawkular-Tenant", (Object)"test").post(null);
        Assert.assertEquals((long)405L, (long)this.response.getStatus());
    }

    @Test
    public void testNotFoundException() {
        this.response = target.clone().path("/gaugesssss/test/data").queryParam("buckets", new Object[]{"999"}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Hawkular-Tenant", (Object)"test").get();
        Assert.assertEquals((long)404L, (long)this.response.getStatus());
    }

    @Test
    public void testNumberFormatException() {
        this.response = target.clone().path("/gauges/test/data").queryParam("buckets", new Object[]{"999999999999999999999999"}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Hawkular-Tenant", (Object)"test").get();
        Assert.assertEquals((long)400L, (long)this.response.getStatus());
    }

    @Test
    public void testNotAcceptableException() {
        this.response = target.clone().path("/gauges/test/data").request(new String[]{"text/plain"}).header("Hawkular-Tenant", (Object)"test").get();
        Assert.assertEquals((long)406L, (long)this.response.getStatus());
    }

    @Test
    public void testNotSupportedException() {
        this.response = target.clone().path("/gauges/test/data").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Content-Type", (Object)"text/plain").header("Hawkular-Tenant", (Object)"test").post(null);
        Assert.assertEquals((long)415L, (long)this.response.getStatus());
    }
}

