/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.test;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.test.InfluxDBTest;
import org.influxdb.dto.Serie;
import org.junit.Assert;
import org.junit.Test;

public class InfluxDatabaseITest
extends InfluxDBTest {
    private String dbName = InfluxDatabaseITest.nextTenantId();

    @Test
    public void testWrite() {
        String timeSeries = "writeTest";
        long startTime = System.currentTimeMillis();
        Serie generatedSerie = InfluxDatabaseITest.getSerie(timeSeries, startTime);
        influxDB.write(this.dbName, TimeUnit.MILLISECONDS, new Serie[]{generatedSerie});
        List series = influxDB.query(this.dbName, "select * from " + timeSeries, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)series);
    }

    @Test
    public void testQueryOrderedAsc() {
        String timeSeries = "queryTestOrderedAsc";
        long startTime = System.currentTimeMillis();
        Serie generatedSerie = InfluxDatabaseITest.getSerie(timeSeries, startTime);
        influxDB.write(this.dbName, TimeUnit.MILLISECONDS, new Serie[]{generatedSerie});
        List series = influxDB.query(this.dbName, "select value from " + timeSeries + " order asc", TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)series);
        this.assertSeriesEquals(generatedSerie, (Serie)series.get(0));
    }

    @Test
    public void testQueryOrderedDesc() {
        String timeSeries = "queryTestOrderedDesc";
        long startTime = System.currentTimeMillis();
        Serie generatedSerie = InfluxDatabaseITest.getSerie(timeSeries, startTime);
        influxDB.write(this.dbName, TimeUnit.MILLISECONDS, new Serie[]{generatedSerie});
        Serie serieSource = new Serie.Builder(timeSeries).columns(new String[]{"time", "value"}).values(new Object[]{(startTime -= 9000L) + 8000L, 18.9}).values(new Object[]{startTime + 7000L, 17.9}).values(new Object[]{startTime + 6000L, 16.9}).values(new Object[]{startTime + 5000L, 15.9}).values(new Object[]{startTime + 4000L, 14.9}).values(new Object[]{startTime + 3000L, 13.9}).values(new Object[]{startTime + 2000L, 12.9}).values(new Object[]{startTime + 1000L, 11.9}).values(new Object[]{startTime, 10.9}).build();
        List series = influxDB.query(this.dbName, "select value from " + timeSeries + " order desc", TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)series);
        this.assertSeriesEquals(serieSource, (Serie)series.get(0));
    }

    @Test
    public void testQueryLimitClause() {
        String timeSeries = "queryTestLimitClause";
        long startTime = System.currentTimeMillis();
        Serie generatedSerie = InfluxDatabaseITest.getSerie(timeSeries, startTime);
        influxDB.write(this.dbName, TimeUnit.MILLISECONDS, new Serie[]{generatedSerie});
        Serie serieSource = new Serie.Builder(timeSeries).columns(new String[]{"time", "value"}).values(new Object[]{startTime -= 9000L, 10.9}).values(new Object[]{startTime + 1000L, 11.9}).values(new Object[]{startTime + 2000L, 12.9}).build();
        List series = influxDB.query(this.dbName, "select value from " + timeSeries + " limit 3 order asc", TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)series);
        this.assertSeriesEquals(serieSource, (Serie)series.get(0));
    }

    @Test
    public void testQueryTop() {
        String timeSeries = "queryTestTop";
        long startTime = System.currentTimeMillis();
        Serie generatedSerie = InfluxDatabaseITest.getSerie(timeSeries, startTime);
        influxDB.write(this.dbName, TimeUnit.MILLISECONDS, new Serie[]{generatedSerie});
        Serie serieSource = new Serie.Builder(timeSeries).columns(new String[]{"time", "top"}).values(new Object[]{(startTime -= 9000L) + 8000L, 18.9}).values(new Object[]{startTime + 7000L, 17.9}).values(new Object[]{startTime + 6000L, 16.9}).build();
        List series = influxDB.query(this.dbName, "select top(value, 3) from " + timeSeries + " where time > now() - 30s group by time(30s)", TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)series);
        this.assertSeriesEquals(serieSource, (Serie)series.get(0));
    }

    @Test
    public void testQueryBottom() {
        String timeSeries = "queryTestBottom";
        long startTime = System.currentTimeMillis();
        Serie generatedSerie = InfluxDatabaseITest.getSerie(timeSeries, startTime);
        influxDB.write(this.dbName, TimeUnit.MILLISECONDS, new Serie[]{generatedSerie});
        Serie serieSource = new Serie.Builder(timeSeries).columns(new String[]{"time", "bottom"}).values(new Object[]{startTime -= 9000L, 10.9}).values(new Object[]{startTime + 1000L, 11.9}).values(new Object[]{startTime + 2000L, 12.9}).build();
        List series = influxDB.query(this.dbName, "select bottom(value, 3) from " + timeSeries + " where time > now() - 30s group by time(30s)", TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)series);
        this.assertSeriesEquals(serieSource, (Serie)series.get(0));
    }

    @Test
    public void testQueryStddev() {
        String timeSeries = "queryTestStddev";
        long startTime = System.currentTimeMillis();
        Serie generatedSerie = InfluxDatabaseITest.getSerie(timeSeries, startTime);
        influxDB.write(this.dbName, TimeUnit.MILLISECONDS, new Serie[]{generatedSerie});
        Serie serieSource = new Serie.Builder(timeSeries).columns(new String[]{"time", "stddev"}).values(new Object[]{(startTime -= 9000L) + 8000L, 2.7386127875258}).build();
        List series = influxDB.query(this.dbName, "select stddev(value) from " + timeSeries + " where time > now() - 30s group by time(30s)", TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)series);
        this.assertSeriesEquals(serieSource, (Serie)series.get(0));
    }

    @Test
    public void testQueryMean() {
        String timeSeries = "queryTestMean";
        long startTime = System.currentTimeMillis();
        Serie generatedSerie = InfluxDatabaseITest.getSerie(timeSeries, startTime);
        influxDB.write(this.dbName, TimeUnit.MILLISECONDS, new Serie[]{generatedSerie});
        Serie serieSource = new Serie.Builder(timeSeries).columns(new String[]{"time", "mean"}).values(new Object[]{(startTime -= 9000L) + 8000L, 14.9}).build();
        List series = influxDB.query(this.dbName, "select mean(value) from " + timeSeries + " where time > now() - 30s group by time(30s)", TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)series);
        this.assertSeriesEquals(serieSource, (Serie)series.get(0));
    }

    @Test
    public void testQuerySum() {
        String timeSeries = "queryTestSum";
        long startTime = System.currentTimeMillis();
        Serie generatedSerie = InfluxDatabaseITest.getSerie(timeSeries, startTime);
        influxDB.write(this.dbName, TimeUnit.MILLISECONDS, new Serie[]{generatedSerie});
        Serie serieSource = new Serie.Builder(timeSeries).columns(new String[]{"time", "sum"}).values(new Object[]{(startTime -= 9000L) + 8000L, 134.1}).build();
        List series = influxDB.query(this.dbName, "select sum(value) from " + timeSeries + " where time > now() - 30s group by time(30s)", TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)series);
        this.assertSeriesEquals(serieSource, (Serie)series.get(0));
    }

    private void assertSeriesEquals(Serie serieOne, Serie serieTwo) {
        Assert.assertNotNull((Object)serieOne);
        Assert.assertNotNull((Object)serieTwo);
        Assert.assertEquals((Object)serieOne.getName(), (Object)serieTwo.getName());
        Assert.assertEquals((long)serieOne.getRows().size(), (long)serieTwo.getRows().size());
        Assert.assertArrayEquals((Object[])serieOne.getColumns(), (Object[])serieTwo.getColumns());
        for (int rowNo = 0; rowNo < serieOne.getRows().size(); ++rowNo) {
            for (String column : serieOne.getColumns()) {
                if (column.equals("time")) {
                    Assert.assertEquals((double)Float.valueOf(((Map)serieOne.getRows().get(rowNo)).get(column).toString()).floatValue(), (double)Float.valueOf(((Map)serieTwo.getRows().get(rowNo)).get(column).toString()).floatValue(), (double)1.0E-7);
                    continue;
                }
                Assert.assertEquals((double)Double.valueOf(((Map)serieOne.getRows().get(rowNo)).get(column).toString()), (double)Double.valueOf(((Map)serieTwo.getRows().get(rowNo)).get(column).toString()), (double)1.0E-13);
            }
        }
    }

    private static Serie getSerie(String timeSeries, long startTime) {
        return new Serie.Builder(timeSeries).columns(new String[]{"time", "value"}).values(new Object[]{startTime -= 9000L, 10.9}).values(new Object[]{startTime + 1000L, 11.9}).values(new Object[]{startTime + 2000L, 12.9}).values(new Object[]{startTime + 3000L, 13.9}).values(new Object[]{startTime + 4000L, 14.9}).values(new Object[]{startTime + 5000L, 15.9}).values(new Object[]{startTime + 6000L, 16.9}).values(new Object[]{startTime + 7000L, 17.9}).values(new Object[]{startTime + 8000L, 18.9}).build();
    }
}

