/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.QueryConsistencyException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;

public class WriteFailureException
extends QueryConsistencyException {
    private final WriteType writeType;
    private final int failed;
    private final Map<InetAddress, Integer> failuresMap;

    public WriteFailureException(ConsistencyLevel consistency, WriteType writeType, int received, int required, int failed, Map<InetAddress, Integer> failuresMap) {
        this(null, consistency, writeType, received, required, failed, failuresMap);
    }

    @Deprecated
    public WriteFailureException(ConsistencyLevel consistency, WriteType writeType, int received, int required, int failed) {
        this(null, consistency, writeType, received, required, failed, Collections.emptyMap());
    }

    public WriteFailureException(InetSocketAddress address, ConsistencyLevel consistency, WriteType writeType, int received, int required, int failed, Map<InetAddress, Integer> failuresMap) {
        super(address, String.format("Cassandra failure during write query at consistency %s (%d responses were required but only %d replica responded, %d failed)", new Object[]{consistency, required, received, failed}), consistency, received, required);
        this.writeType = writeType;
        this.failed = failed;
        this.failuresMap = failuresMap;
    }

    @Deprecated
    public WriteFailureException(InetSocketAddress address, ConsistencyLevel consistency, WriteType writeType, int received, int required, int failed) {
        this(address, consistency, writeType, received, required, failed, Collections.emptyMap());
    }

    private WriteFailureException(InetSocketAddress address, String msg, Throwable cause, ConsistencyLevel consistency, WriteType writeType, int received, int required, int failed, Map<InetAddress, Integer> failuresMap) {
        super(address, msg, cause, consistency, received, required);
        this.writeType = writeType;
        this.failed = failed;
        this.failuresMap = failuresMap;
    }

    public WriteType getWriteType() {
        return this.writeType;
    }

    public int getFailures() {
        return this.failed;
    }

    public Map<InetAddress, Integer> getFailuresMap() {
        return this.failuresMap;
    }

    @Override
    public WriteFailureException copy() {
        return new WriteFailureException(this.getAddress(), this.getMessage(), this, this.getConsistencyLevel(), this.getWriteType(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements(), this.getFailures(), this.failuresMap);
    }

    public WriteFailureException copy(InetSocketAddress address) {
        return new WriteFailureException(address, this.getMessage(), this, this.getConsistencyLevel(), this.getWriteType(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements(), this.failed, this.failuresMap);
    }
}

