/*
 * Decompiled with CFR 0.152.
 */
package rx.transformer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import rx.Observable;
import rx.functions.Action2;
import rx.functions.Func0;
import rx.functions.Func1;

public final class GuavaTransformers {
    private GuavaTransformers() {
    }

    public static <T> Observable.Transformer<T, ImmutableList<T>> toImmutableList() {
        return new Observable.Transformer<T, ImmutableList<T>>(){

            @Override
            public Observable<ImmutableList<T>> call(Observable<T> source) {
                return source.collect(new Func0<ImmutableList.Builder<T>>(){

                    @Override
                    public ImmutableList.Builder<T> call() {
                        return ImmutableList.builder();
                    }
                }, new Action2<ImmutableList.Builder<T>, T>(){

                    @Override
                    public void call(ImmutableList.Builder<T> builder, T t) {
                        builder.add(t);
                    }
                }).map(new Func1<ImmutableList.Builder<T>, ImmutableList<T>>(){

                    @Override
                    public ImmutableList<T> call(ImmutableList.Builder<T> builder) {
                        return builder.build();
                    }
                });
            }
        };
    }

    public static <T> Observable.Transformer<T, ImmutableSet<T>> toImmutableSet() {
        return new Observable.Transformer<T, ImmutableSet<T>>(){

            @Override
            public Observable<ImmutableSet<T>> call(Observable<T> source) {
                return source.collect(new Func0<ImmutableSet.Builder<T>>(){

                    @Override
                    public ImmutableSet.Builder<T> call() {
                        return ImmutableSet.builder();
                    }
                }, new Action2<ImmutableSet.Builder<T>, T>(){

                    @Override
                    public void call(ImmutableSet.Builder<T> builder, T t) {
                        builder.add(t);
                    }
                }).map(new Func1<ImmutableSet.Builder<T>, ImmutableSet<T>>(){

                    @Override
                    public ImmutableSet<T> call(ImmutableSet.Builder<T> builder) {
                        return builder.build();
                    }
                });
            }
        };
    }

    public static <T, K, V> Observable.Transformer<T, ImmutableMap<K, V>> toImmutableMap(final Func1<T, K> keyMapper, final Func1<T, V> valueMapper) {
        return new Observable.Transformer<T, ImmutableMap<K, V>>(){

            @Override
            public Observable<ImmutableMap<K, V>> call(Observable<T> observable) {
                return observable.collect(new Func0<ImmutableMap.Builder<K, V>>(){

                    @Override
                    public ImmutableMap.Builder<K, V> call() {
                        return ImmutableMap.builder();
                    }
                }, new Action2<ImmutableMap.Builder<K, V>, T>(){

                    @Override
                    public void call(ImmutableMap.Builder<K, V> builder, T t) {
                        builder.put(keyMapper.call(t), valueMapper.call(t));
                    }
                }).map(new Func1<ImmutableMap.Builder<K, V>, ImmutableMap<K, V>>(){

                    @Override
                    public ImmutableMap<K, V> call(ImmutableMap.Builder<K, V> builder) {
                        return builder.build();
                    }
                });
            }
        };
    }

    public static <T, K, V> Observable.Transformer<T, ImmutableListMultimap<K, V>> toImmutableListMultimap(final Func1<T, K> keyMapper, final Func1<T, V> valueMapper) {
        return new Observable.Transformer<T, ImmutableListMultimap<K, V>>(){

            @Override
            public Observable<ImmutableListMultimap<K, V>> call(Observable<T> observable) {
                return observable.collect(new Func0<ImmutableListMultimap.Builder<K, V>>(){

                    @Override
                    public ImmutableListMultimap.Builder<K, V> call() {
                        return ImmutableListMultimap.builder();
                    }
                }, new Action2<ImmutableListMultimap.Builder<K, V>, T>(){

                    @Override
                    public void call(ImmutableListMultimap.Builder<K, V> builder, T t) {
                        builder.put(keyMapper.call(t), valueMapper.call(t));
                    }
                }).map(new Func1<ImmutableListMultimap.Builder<K, V>, ImmutableListMultimap<K, V>>(){

                    @Override
                    public ImmutableListMultimap<K, V> call(ImmutableListMultimap.Builder<K, V> builder) {
                        return builder.build();
                    }
                });
            }
        };
    }
}

