/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.rx.cassandra.driver;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Iterator;
import org.hawkular.rx.cassandra.driver.ResultSetToRowsTransformer;
import org.hawkular.rx.cassandra.driver.RxSession;
import rx.Observable;
import rx.Scheduler;
import rx.observable.ListenableFutureObservable;
import rx.schedulers.Schedulers;

public class RxSessionImpl
implements RxSession {
    private Session session;
    private LoadBalancingPolicy loadBalancingPolicy;
    private int maxInFlightLocal = 0;
    private int maxInFlightRemote = 0;

    public RxSessionImpl(Session session) {
        this.session = session;
        this.loadBalancingPolicy = session.getCluster().getConfiguration().getPolicies().getLoadBalancingPolicy();
        PoolingOptions poolingOptions = session.getCluster().getConfiguration().getPoolingOptions();
        this.maxInFlightLocal = poolingOptions.getCoreConnectionsPerHost(HostDistance.LOCAL) * poolingOptions.getMaxRequestsPerConnection(HostDistance.LOCAL);
        this.maxInFlightRemote = poolingOptions.getCoreConnectionsPerHost(HostDistance.REMOTE) * poolingOptions.getMaxRequestsPerConnection(HostDistance.REMOTE);
    }

    @Override
    public String getLoggedKeyspace() {
        return this.session.getLoggedKeyspace();
    }

    @Override
    public RxSession init() {
        this.session.init();
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean availableInFlightSlots(Statement st) {
        boolean available = false;
        Iterator<Host> hostIterator = this.loadBalancingPolicy.newQueryPlan(this.session.getLoggedKeyspace(), st);
        while (hostIterator.hasNext()) {
            Host host = hostIterator.next();
            int inFlightQueries = this.session.getState().getInFlightQueries(host);
            switch (this.loadBalancingPolicy.distance(host)) {
                case LOCAL: {
                    if (inFlightQueries >= this.maxInFlightLocal) break;
                    return true;
                }
                case REMOTE: {
                    if (inFlightQueries >= this.maxInFlightRemote) break;
                    return true;
                }
            }
        }
        return available;
    }

    private Observable<ResultSet> scheduleStatement(Statement st, Scheduler scheduler) {
        while (true) {
            if (this.availableInFlightSlots(st)) {
                ResultSetFuture future = this.session.executeAsync(st);
                return ListenableFutureObservable.from(future, scheduler);
            }
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    @Override
    public Observable<ResultSet> execute(String query) {
        return this.scheduleStatement(new SimpleStatement(query), Schedulers.computation());
    }

    @Override
    public Observable<Row> executeAndFetch(String query) {
        return this.execute(query).compose(new ResultSetToRowsTransformer());
    }

    @Override
    public Observable<ResultSet> execute(String query, Scheduler scheduler) {
        return this.scheduleStatement(new SimpleStatement(query), scheduler);
    }

    @Override
    public Observable<Row> executeAndFetch(String query, Scheduler scheduler) {
        return this.execute(query, scheduler).compose(new ResultSetToRowsTransformer(scheduler));
    }

    @Override
    public Observable<ResultSet> execute(String query, Object ... values) {
        ResultSetFuture future = this.session.executeAsync(query, values);
        return ListenableFutureObservable.from(future, Schedulers.computation());
    }

    @Override
    public Observable<Row> executeAndFetch(String query, Object ... values) {
        return this.execute(query, values).compose(new ResultSetToRowsTransformer());
    }

    @Override
    public Observable<ResultSet> execute(String query, Scheduler scheduler, Object ... values) {
        ResultSetFuture future = this.session.executeAsync(query, values, scheduler);
        return ListenableFutureObservable.from(future, scheduler);
    }

    @Override
    public Observable<Row> executeAndFetch(String query, Scheduler scheduler, Object ... values) {
        return this.execute(query, scheduler, values).compose(new ResultSetToRowsTransformer(scheduler));
    }

    @Override
    public Observable<ResultSet> execute(Statement statement) {
        return this.scheduleStatement(statement, Schedulers.computation());
    }

    @Override
    public Observable<Row> executeAndFetch(Statement statement) {
        return this.execute(statement).compose(new ResultSetToRowsTransformer());
    }

    @Override
    public Observable<ResultSet> execute(Statement statement, Scheduler scheduler) {
        return this.scheduleStatement(statement, scheduler);
    }

    @Override
    public Observable<Row> executeAndFetch(Statement statement, Scheduler scheduler) {
        return this.execute(statement, scheduler).compose(new ResultSetToRowsTransformer(scheduler));
    }

    @Override
    public Observable<PreparedStatement> prepare(String query) {
        ListenableFuture<PreparedStatement> future = this.session.prepareAsync(query);
        return ListenableFutureObservable.from(future, Schedulers.computation());
    }

    @Override
    public Observable<PreparedStatement> prepare(String query, Scheduler scheduler) {
        ListenableFuture<PreparedStatement> future = this.session.prepareAsync(query);
        return ListenableFutureObservable.from(future, scheduler);
    }

    @Override
    public Observable<PreparedStatement> prepare(RegularStatement statement) {
        ListenableFuture<PreparedStatement> future = this.session.prepareAsync(statement);
        return ListenableFutureObservable.from(future, Schedulers.computation());
    }

    @Override
    public Observable<PreparedStatement> prepare(RegularStatement statement, Scheduler scheduler) {
        ListenableFuture<PreparedStatement> future = this.session.prepareAsync(statement);
        return ListenableFutureObservable.from(future, scheduler);
    }

    @Override
    public void close() {
        this.session.close();
    }

    @Override
    public boolean isClosed() {
        return this.session.isClosed();
    }

    @Override
    public Cluster getCluster() {
        return this.session.getCluster();
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Session.State getState() {
        return this.session.getState();
    }
}

