/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.datetime;

import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjuster;
import java.util.function.Supplier;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.Hours;
import org.joda.time.Period;

public class DateTimeService {
    public static Supplier<DateTime> now;

    public static DateTime currentMinute() {
        return DateTimeService.getTimeSlice(now.get(), Duration.standardMinutes(1L));
    }

    public static DateTime currentHour() {
        return DateTimeService.getTimeSlice(now.get(), Hours.ONE.toStandardDuration());
    }

    public static DateTime current24HourTimeSlice() {
        return DateTimeService.get24HourTimeSlice(DateTimeService.currentHour());
    }

    public static DateTime get24HourTimeSlice(DateTime time) {
        return DateTimeService.getTimeSlice(time, Days.ONE.toStandardDuration());
    }

    public static long getTimeSlice(long time, Duration duration) {
        return DateTimeService.getTimeSlice(new DateTime(time), duration).getMillis();
    }

    public static DateTime getTimeSlice(DateTime dt, Duration duration) {
        Period p = duration.toPeriod();
        if (p.getYears() != 0) {
            return dt.yearOfEra().roundFloorCopy().minusYears(dt.getYearOfEra() % p.getYears());
        }
        if (p.getMonths() != 0) {
            return dt.monthOfYear().roundFloorCopy().minusMonths((dt.getMonthOfYear() - 1) % p.getMonths());
        }
        if (p.getWeeks() != 0) {
            return dt.weekOfWeekyear().roundFloorCopy().minusWeeks((dt.getWeekOfWeekyear() - 1) % p.getWeeks());
        }
        if (p.getDays() != 0) {
            return dt.dayOfMonth().roundFloorCopy().minusDays((dt.getDayOfMonth() - 1) % p.getDays());
        }
        if (p.getHours() != 0) {
            return dt.hourOfDay().roundFloorCopy().minusHours(dt.getHourOfDay() % p.getHours());
        }
        if (p.getMinutes() != 0) {
            return dt.minuteOfHour().roundFloorCopy().minusMinutes(dt.getMinuteOfHour() % p.getMinutes());
        }
        if (p.getSeconds() != 0) {
            return dt.secondOfMinute().roundFloorCopy().minusSeconds(dt.getSecondOfMinute() % p.getSeconds());
        }
        return dt.millisOfSecond().roundCeilingCopy().minusMillis(dt.getMillisOfSecond() % p.getMillis());
    }

    public static TemporalAdjuster startOfNextOddHour() {
        return temporal -> {
            int currentHour = temporal.get(ChronoField.HOUR_OF_DAY);
            return temporal.plus(currentHour % 2 == 0 ? 1L : 2L, ChronoUnit.HOURS).with(ChronoField.MINUTE_OF_HOUR, 0L).with(ChronoField.SECOND_OF_MINUTE, 0L).with(ChronoField.NANO_OF_SECOND, 0L);
        };
    }

    public static TemporalAdjuster startOfPreviousEvenHour() {
        return temporal -> {
            int currentHour = temporal.get(ChronoField.HOUR_OF_DAY);
            return temporal.minus(currentHour % 2 == 0 ? 0L : 1L, ChronoUnit.HOURS).with(ChronoField.MINUTE_OF_HOUR, 0L).with(ChronoField.SECOND_OF_MINUTE, 0L).with(ChronoField.NANO_OF_SECOND, 0L);
        };
    }

    static {
        DateTimeZone.setDefault(DateTimeZone.UTC);
        now = DateTime::now;
    }
}

