/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.schema;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Manifest;

public class VersionUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        try {
            Enumeration<URL> resources = VersionUtil.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                InputStream stream = resource.openStream();
                Throwable throwable = null;
                try {
                    String gitSHA;
                    String implVersion;
                    Manifest manifest = new Manifest(stream);
                    String vendorId = manifest.getMainAttributes().getValue("Implementation-Vendor-Id");
                    if (!VersionUtil.isValidManifest(vendorId, implVersion = manifest.getMainAttributes().getValue("Implementation-Version"), gitSHA = manifest.getMainAttributes().getValue("Built-From-Git-SHA1"))) continue;
                    String string = implVersion + "+" + gitSHA.substring(0, 10);
                    return string;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            throw new RuntimeException("Unable to determine implementation version for Hawkular Metrics");
        }
        catch (IOException e) {
            throw new RuntimeException("There was an I/O error reading META-INF/MANIFEST.MF", e);
        }
    }

    private static boolean isValidManifest(String vendorId, String implVersion, String gitSHA) {
        return vendorId != null && vendorId.equals("org.hawkular.metrics") && !Strings.isNullOrEmpty(implVersion) && !Strings.isNullOrEmpty(gitSHA);
    }
}

