/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.schema;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import org.cassalog.core.Cassalog;
import org.cassalog.core.CassalogBuilder;

public class SchemaService {
    public void run(Session session, String keyspace, boolean resetDB) {
        this.run(session, keyspace, resetDB, 1);
    }

    public void run(Session session, String keyspace, boolean resetDB, int replicationFactor) {
        CassalogBuilder builder = new CassalogBuilder();
        Cassalog cassalog = builder.withKeyspace(keyspace).withSession(session).build();
        ImmutableMap vars = ImmutableMap.of((Object)"keyspace", (Object)keyspace, (Object)"reset", (Object)resetDB, (Object)"session", (Object)session, (Object)"replicationFactor", (Object)replicationFactor);
        List<String> tags = Arrays.asList("0.15.x", "0.18.x", "0.19.x", "0.20.x", "0.21.x", "0.23.x");
        URI script = this.getScript();
        cassalog.execute(script, tags, (Map)vars);
        session.execute("INSERT INTO " + keyspace + ".sys_config (config_id, name, value) VALUES ('org.hawkular.metrics', 'version', '" + this.getNewHawkularMetricsVersion() + "')");
    }

    private URI getScript() {
        try {
            return this.getClass().getResource("/org/hawkular/schema/cassalog.groovy").toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to load schema change script", e);
        }
    }

    private boolean systemSettingsTableExists(Session session, String keyspace) {
        SimpleStatement statement = new SimpleStatement("SELECT * FROM sysconfig.schema_columnfamilies WHERE keyspace_name = '" + keyspace + "' AND columnfamily_name = 'system_settings'");
        ResultSet resultSet = session.execute((Statement)statement);
        return !resultSet.isExhausted();
    }

    private String getCurrentHawkularMetricsVersion(Session session, String keyspace) {
        SimpleStatement statement = new SimpleStatement("SELECT value FROM " + keyspace + ".sys_config WHERE name = 'org.hawkular.metrics.version'");
        ResultSet resultSet = session.execute((Statement)statement);
        if (resultSet.isExhausted()) {
            return null;
        }
        return ((Row)resultSet.all().get(0)).getString(0);
    }

    private String getNewHawkularMetricsVersion() {
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                Manifest manifest = new Manifest(resource.openStream());
                String vendorId = manifest.getMainAttributes().getValue("Implementation-Vendor-Id");
                if (vendorId == null || !vendorId.equals("org.hawkular.metrics")) continue;
                return manifest.getMainAttributes().getValue("Implementation-Version");
            }
            throw new RuntimeException("Unable to determine implementation version for Hawkular Metrics");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

