/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.schema;

import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.cassalog.core.Cassalog;
import org.cassalog.core.CassalogBuilder;
import org.hawkular.metrics.schema.VersionUpdateException;
import org.hawkular.metrics.schema.VersionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaService {
    private static Logger logger = LoggerFactory.getLogger(SchemaService.class);

    public void run(Session session, String keyspace, boolean resetDB) {
        this.run(session, keyspace, resetDB, 1);
    }

    public void run(Session session, String keyspace, boolean resetDB, int replicationFactor) {
        this.run(session, keyspace, resetDB, replicationFactor, false);
    }

    public void run(Session session, String keyspace, boolean resetDB, int replicationFactor, boolean updateVersion) {
        CassalogBuilder builder = new CassalogBuilder();
        Cassalog cassalog = builder.withKeyspace(keyspace).withSession(session).build();
        ImmutableMap vars = ImmutableMap.of((Object)"keyspace", (Object)keyspace, (Object)"reset", (Object)resetDB, (Object)"session", (Object)session, (Object)"replicationFactor", (Object)replicationFactor, (Object)"logger", (Object)logger);
        List<String> tags = Arrays.asList("0.15.x", "0.18.x", "0.19.x", "0.20.x", "0.21.x", "0.23.x", "0.26.x", "0.27.x", "0.30.x");
        URI script = this.getScript();
        cassalog.execute(script, tags, (Map)vars);
        if (updateVersion) {
            this.updateVersion(session, keyspace, 0L, 0);
        }
    }

    public void updateVersion(Session session, String keyspace, long delay, int maxRetries) {
        this.doVersionUpdate(session, keyspace, delay, maxRetries);
    }

    private void doVersionUpdate(Session session, String keyspace, long delay, int maxRetries) {
        String configId = "org.hawkular.metrics";
        String configName = "version";
        String version = VersionUtil.getVersion();
        SimpleStatement updateVersion = new SimpleStatement("INSERT INTO sys_config (config_id, name, value) VALUES (?, ?, ?)", new Object[]{configId, configName, version}).setKeyspace(keyspace);
        int retries = 0;
        while (true) {
            try {
                session.execute((Statement)updateVersion);
                logger.info("Updated system configuration to version {}", (Object)version);
                break;
            }
            catch (Exception e) {
                if (++retries > maxRetries) {
                    throw new VersionUpdateException("Failed to update version in system configuration after " + maxRetries + " attempts.", e);
                }
                logger.warn("Failed to update version in system configuration. Retrying in " + delay + " ms", (Throwable)e);
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e1) {
                    throw new VersionUpdateException("Aborting version update due to interrupt", e1);
                }
            }
        }
    }

    private URI getScript() {
        try {
            return this.getClass().getResource("/org/hawkular/schema/cassalog.groovy").toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to load schema change script", e);
        }
    }
}

