/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.param;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.ext.ParamConverter;
import org.hawkular.metrics.model.param.TagNames;

public class TagNamesConverter
implements ParamConverter<TagNames> {
    public TagNames fromString(String value) {
        String[] tokens = value.split(",", -1);
        Set names = Arrays.stream(tokens).map(token -> {
            if (token.trim().isEmpty()) {
                throw new IllegalArgumentException("Invalid tag list:" + value);
            }
            String[] parts = token.split(":", -1);
            if (parts.length > 2) {
                throw new IllegalArgumentException("Invalid tag list:" + value);
            }
            String key = parts[0];
            if (key.trim().isEmpty()) {
                throw new IllegalArgumentException("Invalid tag list:" + value);
            }
            return key;
        }).collect(Collectors.toSet());
        return new TagNames(names);
    }

    public String toString(TagNames value) {
        return value.getNames().stream().collect(Collectors.joining(","));
    }
}

