/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.PatternSyntaxException;
import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.AggregatedStatsQueryRequest;
import org.hawkular.metrics.api.jaxrs.QueryRequest;
import org.hawkular.metrics.api.jaxrs.handler.MetricsServiceHandler;
import org.hawkular.metrics.api.jaxrs.handler.observer.MetricCreatedObserver;
import org.hawkular.metrics.api.jaxrs.handler.observer.ResultSetObserver;
import org.hawkular.metrics.api.jaxrs.handler.template.IMetricsHandler;
import org.hawkular.metrics.api.jaxrs.param.TimeAndBucketParams;
import org.hawkular.metrics.api.jaxrs.param.TimeAndSortParams;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.api.jaxrs.util.Logged;
import org.hawkular.metrics.core.service.Functions;
import org.hawkular.metrics.core.service.Order;
import org.hawkular.metrics.core.service.transformers.MinMaxTimestampTransformer;
import org.hawkular.metrics.model.ApiError;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.NumericBucketPoint;
import org.hawkular.metrics.model.TaggedBucketPoint;
import org.hawkular.metrics.model.exception.RuntimeApiError;
import org.hawkular.metrics.model.param.BucketConfig;
import org.hawkular.metrics.model.param.Duration;
import org.hawkular.metrics.model.param.Percentiles;
import org.hawkular.metrics.model.param.TagNames;
import org.hawkular.metrics.model.param.Tags;
import org.hawkular.metrics.model.param.TimeRange;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.GZIP;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.schedulers.Schedulers;

@Path(value="/gauges")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@GZIP
@Api(tags={"Gauge"})
@ApplicationScoped
@Logged
public class GaugeHandler
extends MetricsServiceHandler
implements IMetricsHandler<Double> {
    private Logger logger = Logger.getLogger(GaugeHandler.class);

    @POST
    @Path(value="/")
    @ApiOperation(value="Create gauge metric.", notes="Clients are not required to explicitly create a metric before storing data. Doing so however allows clients to prevent naming collisions and to specify tags and data retention.")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric created successfully"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=409, message="Gauge metric with given id already exists", response=ApiError.class), @ApiResponse(code=500, message="Metric creation failed due to an unexpected error", response=ApiError.class)})
    public void createMetric(@Suspended AsyncResponse asyncResponse, @ApiParam(required=true) Metric<Double> metric, @ApiParam(value="Overwrite previously created metric configuration if it exists. Only data retention and tags are overwriten; existing data points are unnafected. Defaults to false.") @DefaultValue(value="false") @QueryParam(value="overwrite") Boolean overwrite, @Context UriInfo uriInfo) {
        if (metric.getType() != null && MetricType.UNDEFINED != metric.getType() && MetricType.GAUGE != metric.getType()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Metric type does not match " + MetricType.GAUGE.getText())));
        }
        metric = new Metric(new MetricId(this.getTenant(), MetricType.GAUGE, metric.getId()), metric.getTags(), metric.getDataRetention());
        URI location = uriInfo.getBaseUriBuilder().path("/gauges/{id}").build(new Object[]{metric.getMetricId().getName()});
        this.metricsService.createMetric(metric, overwrite.booleanValue()).subscribe((Observer)new MetricCreatedObserver(asyncResponse, location));
    }

    @GET
    @Path(value="/")
    @ApiOperation(value="Find tenant's metric definitions.", notes="Does not include any metric values. ", response=Metric.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved at least one metric definition."), @ApiResponse(code=204, message="No metrics found."), @ApiResponse(code=400, message="Invalid type parameter type.", response=ApiError.class), @ApiResponse(code=500, message="Failed to retrieve metrics due to unexpected error.", response=ApiError.class)})
    public void getMetrics(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of tags filters") @QueryParam(value="tags") String tags, @ApiParam(value="Fetch min and max timestamps of available datapoints") @DefaultValue(value="false") @QueryParam(value="timestamps") Boolean fetchTimestamps) {
        Observable metricObservable = null;
        metricObservable = tags != null ? this.metricsService.findMetricsWithFilters(this.getTenant(), MetricType.GAUGE, tags) : this.metricsService.findMetrics(this.getTenant(), MetricType.GAUGE);
        if (fetchTimestamps.booleanValue()) {
            metricObservable = metricObservable.compose((Observable.Transformer)new MinMaxTimestampTransformer(this.metricsService));
        }
        metricObservable.toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> {
            if (t instanceof PatternSyntaxException) {
                asyncResponse.resume((Object)ApiUtils.badRequest((Throwable)t));
            } else {
                asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t));
            }
        });
    }

    @GET
    @Path(value="/{id}")
    @ApiOperation(value="Retrieve single metric definition.", response=Metric.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's definition was successfully retrieved."), @ApiResponse(code=204, message="Query was successful, but no metrics definition is set."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric's definition.", response=ApiError.class)})
    public void getMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id) {
        this.metricsService.findMetric(new MetricId(this.getTenant(), MetricType.GAUGE, id)).compose((Observable.Transformer)new MinMaxTimestampTransformer(this.metricsService)).map(metric -> Response.ok((Object)metric).build()).switchIfEmpty(Observable.just((Object)ApiUtils.noContent())).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }

    @DELETE
    @Path(value="/{id}")
    @ApiOperation(value="Deletes the metric and associated uncompressed data points, and updates internal indexes. Note: compressed data will not be deleted immediately. It is deleted as part of the normal data expiration as defined by the data retention settings. Consequently, compressed data will be accessible until it automatically expires.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric deletion was successful."), @ApiResponse(code=500, message="Unexpected error occurred trying to delete the metric.")})
    public void deleteMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id) {
        MetricId metric = new MetricId(this.getTenant(), MetricType.GAUGE, id);
        this.metricsService.deleteMetric(metric).subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @GET
    @Path(value="/tags/{tags}")
    @ApiOperation(value="Retrieve gauge type's tag values", response=Map.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Tags successfully retrieved."), @ApiResponse(code=204, message="No matching tags were found"), @ApiResponse(code=500, message="Unexpected error occurred while fetching tags.", response=ApiError.class)})
    public void getTags(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Tag query") @PathParam(value="tags") Tags tags) {
        this.metricsService.getTagValues(this.getTenant(), MetricType.GAUGE, tags.getTags()).map(ApiUtils::mapToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }

    @GET
    @Path(value="/{id}/tags")
    @ApiOperation(value="Retrieve tags associated with the metric definition.", response=Map.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully retrieved."), @ApiResponse(code=204, message="Query was successful, but no metrics were found."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric's tags.", response=ApiError.class)})
    public void getMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id) {
        this.metricsService.getMetricTags(new MetricId(this.getTenant(), MetricType.GAUGE, id)).map(ApiUtils::mapToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }

    @PUT
    @Path(value="/{id}/tags")
    @ApiOperation(value="Update tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully updated."), @ApiResponse(code=500, message="Unexpected error occurred while updating metric's tags.", response=ApiError.class)})
    public void updateMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(required=true) Map<String, String> tags) {
        Metric metric = new Metric(new MetricId(this.getTenant(), MetricType.GAUGE, id));
        this.metricsService.addTags(metric, tags).subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @DELETE
    @Path(value="/{id}/tags/{tags}")
    @ApiOperation(value="Delete tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully deleted."), @ApiResponse(code=400, message="Invalid tags", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while trying to delete metric's tags.", response=ApiError.class)})
    public void deleteMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Tag names", allowableValues="Comma-separated list of tag names") @PathParam(value="tags") TagNames tags) {
        Metric metric = new Metric(new MetricId(this.getTenant(), MetricType.GAUGE, id));
        this.metricsService.deleteTags(metric, tags.getNames()).subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @POST
    @Path(value="/{id}/raw")
    @ApiOperation(value="Add data for a single gauge metric.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addMetricData(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="List of datapoints containing timestamp and value", required=true) List<DataPoint<Double>> data) {
        Observable metrics = Functions.dataPointToObservable((String)this.getTenant(), (String)id, data, (MetricType)MetricType.GAUGE);
        Observable observable = this.metricsService.addDataPoints(MetricType.GAUGE, metrics);
        observable.subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @Deprecated
    @POST
    @Path(value="/{id}/data")
    @ApiOperation(value="Deprecated. Please use /raw endpoint.")
    public void deprecatedAddDataForMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="List of datapoints containing timestamp and value", required=true) List<DataPoint<Double>> data) {
        this.addMetricData(asyncResponse, id, data);
    }

    @POST
    @Path(value="/raw")
    @ApiOperation(value="Add data for multiple gauge metrics in a single call.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of metrics", required=true) List<Metric<Double>> gauges) {
        Observable metrics = Functions.metricToObservable((String)this.getTenant(), gauges, (MetricType)MetricType.GAUGE);
        Observable observable = this.metricsService.addDataPoints(MetricType.GAUGE, metrics);
        observable.subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @POST
    @Path(value="/raw/query")
    @ApiOperation(value="Fetch raw data points for multiple metrics. This endpoint is experimental and may undergo non-backwards compatible changes in future releases.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric data points."), @ApiResponse(code=204, message="Query was successful, but no data was found."), @ApiResponse(code=400, message="No metric ids are specified", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void getData(@Suspended AsyncResponse asyncResponse, @ApiParam(required=true, value="Query parameters that minimally must include a list of metric ids or tags. The standard start, end, order, and limit query parameters are supported as well.") QueryRequest query) {
        this.findMetricsByNameOrTag(query.getIds(), query.getTags(), MetricType.GAUGE).toList().flatMap(metricIds -> TimeAndSortParams.deferredBuilder((String)query.getStart(), (String)query.getEnd()).fromEarliest(query.getFromEarliest(), metricIds, (arg_0, arg_1, arg_2, arg_3) -> ((GaugeHandler)this).findTimeRange(arg_0, arg_1, arg_2, arg_3)).sortOptions(query.getLimit(), query.getOrder()).toObservable().flatMap(p -> this.metricsService.findDataPoints(metricIds, p.getTimeRange().getStart(), p.getTimeRange().getEnd(), p.getLimit(), p.getOrder()).observeOn(Schedulers.io()))).subscribe((Subscriber)this.createNamedDataPointObserver(asyncResponse, MetricType.GAUGE));
    }

    @POST
    @Path(value="/rate/query")
    @ApiOperation(value="Fetch rate data points for multiple metrics. This endpoint is experimental and may undergo non-backwards compatible changes in future releases.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric rate data points."), @ApiResponse(code=204, message="Query was successful, but no data was found."), @ApiResponse(code=400, message="No metric ids are specified", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void getRateData(@Suspended AsyncResponse asyncResponse, @ApiParam(required=true, value="Query parameters that minimally must include a list of metric ids or tags. The standard start, end, order, and limit query parameters are supported as well.") QueryRequest query) {
        this.findMetricsByNameOrTag(query.getIds(), query.getTags(), MetricType.GAUGE).toList().flatMap(metricIds -> TimeAndSortParams.deferredBuilder((String)query.getStart(), (String)query.getEnd()).fromEarliest(query.getFromEarliest(), metricIds, (arg_0, arg_1, arg_2, arg_3) -> ((GaugeHandler)this).findTimeRange(arg_0, arg_1, arg_2, arg_3)).sortOptions(query.getLimit(), query.getOrder()).toObservable().flatMap(p -> this.metricsService.findRateData(metricIds, p.getTimeRange().getStart(), p.getTimeRange().getEnd(), p.getLimit(), p.getOrder()).observeOn(Schedulers.io()))).subscribe((Subscriber)this.createNamedDataPointObserver(asyncResponse, MetricType.GAUGE_RATE));
    }

    @Deprecated
    @POST
    @Path(value="/data")
    @ApiOperation(value="Deprecated. Please use /raw endpoint.")
    public void deprecatedAddGaugeData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of metrics", required=true) List<Metric<Double>> gauges) {
        this.addData(asyncResponse, gauges);
    }

    @Deprecated
    @GET
    @Path(value="/{id}/data")
    @ApiOperation(value="Deprecated. Please use /raw or /stats endpoints.", response=DataPoint.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric data."), @ApiResponse(code=204, message="No metric data was found."), @ApiResponse(code=400, message="buckets or bucketDuration parameter is invalid, or both are used.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void deprecatedFindGaugeData(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") String start, @ApiParam(value="Defaults to now") @QueryParam(value="end") String end, @ApiParam(value="Use data from earliest received, subject to retention period") @QueryParam(value="fromEarliest") Boolean fromEarliest, @ApiParam(value="Total number of buckets") @QueryParam(value="buckets") Integer bucketsCount, @ApiParam(value="Bucket duration") @QueryParam(value="bucketDuration") Duration bucketDuration, @ApiParam(value="Percentiles to calculate") @QueryParam(value="percentiles") Percentiles percentiles, @ApiParam(value="Limit the number of data points returned") @QueryParam(value="limit") Integer limit, @ApiParam(value="Data point sort order, based on timestamp") @QueryParam(value="order") Order order) {
        Observable observableConfig;
        MetricId metricId = new MetricId(this.getTenant(), MetricType.GAUGE, id);
        if (!(bucketsCount == null && bucketDuration == null || limit == null && order == null)) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Limit and order cannot be used with bucketed results")));
            return;
        }
        if (bucketsCount == null && bucketDuration == null && !Boolean.TRUE.equals(fromEarliest)) {
            TimeRange timeRange = new TimeRange(start, end);
            if (!timeRange.isValid()) {
                asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem())));
                return;
            }
            if (limit == null) {
                limit = 0;
            }
            if (order == null) {
                order = Order.defaultValue((int)limit, (Object)start, (Object)end);
            }
            this.metricsService.findDataPoints(metricId, timeRange.getStart(), timeRange.getEnd(), limit.intValue(), order).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
            return;
        }
        if (Boolean.TRUE.equals(fromEarliest)) {
            if (start != null || end != null) {
                asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("fromEarliest can only be used without start & end")));
                return;
            }
            if (bucketsCount == null && bucketDuration == null) {
                asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("fromEarliest can only be used with bucketed results")));
                return;
            }
            observableConfig = this.metricsService.findMetric(metricId).map(metric -> {
                long dataRetention = (long)(metric.getDataRetention() * 24 * 60 * 60) * 1000L;
                long now = System.currentTimeMillis();
                long earliest = now - dataRetention;
                BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, new TimeRange(Long.valueOf(earliest), Long.valueOf(now)));
                if (!bucketConfig.isValid()) {
                    throw new RuntimeApiError(bucketConfig.getProblem());
                }
                return bucketConfig;
            });
        } else {
            TimeRange timeRange = new TimeRange(start, end);
            if (!timeRange.isValid()) {
                asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem())));
                return;
            }
            BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, timeRange);
            if (!bucketConfig.isValid()) {
                asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(bucketConfig.getProblem())));
                return;
            }
            observableConfig = Observable.just((Object)bucketConfig);
        }
        observableConfig.flatMap(config -> {
            List perc = percentiles == null ? Collections.emptyList() : percentiles.getPercentiles();
            return this.metricsService.findGaugeStats(metricId, config, perc);
        }).flatMap(Observable::from).skipWhile(bucket -> Boolean.TRUE.equals(fromEarliest) && bucket.isEmpty()).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.error((Throwable)t)));
    }

    @GET
    @Path(value="/{id}/raw")
    @ApiOperation(value="Retrieve raw gauge data.", response=DataPoint.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric data."), @ApiResponse(code=204, message="No metric data was found."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void getMetricData(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") String start, @ApiParam(value="Defaults to now") @QueryParam(value="end") String end, @ApiParam(value="Use data from earliest received, subject to retention period") @QueryParam(value="fromEarliest") Boolean fromEarliest, @ApiParam(value="Limit the number of data points returned") @QueryParam(value="limit") Integer limit, @ApiParam(value="Data point sort order, based on timestamp") @QueryParam(value="order") Order order) {
        MetricId metricId = new MetricId(this.getTenant(), MetricType.GAUGE, id);
        TimeAndSortParams.deferredBuilder((String)start, (String)end).fromEarliest(fromEarliest, metricId, (arg_0, arg_1, arg_2, arg_3) -> ((GaugeHandler)this).findTimeRange(arg_0, arg_1, arg_2, arg_3)).sortOptions(limit, order).toObservable().flatMap(p -> this.metricsService.findDataPoints(metricId, p.getTimeRange().getStart(), p.getTimeRange().getEnd(), p.getLimit(), p.getOrder())).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.error((Throwable)t)));
    }

    @GET
    @Path(value="/{id}/stats")
    @ApiOperation(value="Retrieve gauge data.", notes="The time range between start and end will be divided in buckets of equal duration, and metric statistics will be computed for each bucket.", response=NumericBucketPoint.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric data."), @ApiResponse(code=204, message="No metric data was found."), @ApiResponse(code=400, message="buckets or bucketDuration parameter is invalid, or both are used.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void getMetricStats(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") String start, @ApiParam(value="Defaults to now") @QueryParam(value="end") String end, @ApiParam(value="Use data from earliest received, subject to retention period") @QueryParam(value="fromEarliest") Boolean fromEarliest, @ApiParam(value="Total number of buckets") @QueryParam(value="buckets") Integer bucketsCount, @ApiParam(value="Bucket duration") @QueryParam(value="bucketDuration") Duration bucketDuration, @ApiParam(value="Percentiles to calculate") @QueryParam(value="percentiles") Percentiles percentiles) {
        MetricId metricId = new MetricId(this.getTenant(), MetricType.GAUGE, id);
        TimeAndBucketParams.deferredBuilder((String)start, (String)end).fromEarliest(fromEarliest, metricId, (arg_0, arg_1, arg_2, arg_3) -> ((GaugeHandler)this).findTimeRange(arg_0, arg_1, arg_2, arg_3)).bucketConfig(bucketsCount, bucketDuration).percentiles(percentiles).toObservable().flatMap(p -> this.metricsService.findGaugeStats(metricId, p.getBucketConfig(), p.getPercentiles())).flatMap(Observable::from).skipWhile(bucket -> Boolean.TRUE.equals(fromEarliest) && bucket.isEmpty()).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.error((Throwable)t)));
    }

    @GET
    @Path(value="/stats")
    @ApiOperation(value="Find stats for multiple metrics.", notes="Fetches data points from one or more metrics that are determined using either a tags filter or a list of metric names. The time range between start and end is divided into buckets of equal size (i.e., duration) using either the buckets or bucketDuration parameter. Functions are applied to the data points in each bucket to produce statistics on aggregated metrics.", response=NumericBucketPoint.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric data."), @ApiResponse(code=204, message="No metric data was found."), @ApiResponse(code=400, message="The tags parameter is required. Either the buckets or the bucketDuration parameter is required but not both.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void getStats(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") String start, @ApiParam(value="Defaults to now") @QueryParam(value="end") String end, @ApiParam(value="Use data from earliest received, subject to retention period") @QueryParam(value="fromEarliest") Boolean fromEarliest, @ApiParam(value="Total number of buckets") @QueryParam(value="buckets") Integer bucketsCount, @ApiParam(value="Bucket duration") @QueryParam(value="bucketDuration") Duration bucketDuration, @ApiParam(value="Percentiles to calculate") @QueryParam(value="percentiles") Percentiles percentiles, @ApiParam(value="List of tags filters") @QueryParam(value="tags") String tags, @ApiParam(value="List of metric names") @QueryParam(value="metrics") List<String> metricNames, @ApiParam(value="Downsample method (if true then sum of stacked individual stats; defaults to false)") @DefaultValue(value="false") @QueryParam(value="stacked") Boolean stacked) {
        this.findMetricsByNameOrTag(metricNames, tags, MetricType.GAUGE).toList().flatMap(metricIds -> TimeAndBucketParams.deferredBuilder((String)start, (String)end).fromEarliest(fromEarliest, metricIds, (arg_0, arg_1, arg_2, arg_3) -> ((GaugeHandler)this).findTimeRange(arg_0, arg_1, arg_2, arg_3)).bucketConfig(bucketsCount, bucketDuration).percentiles(percentiles).toObservable().flatMap(p -> this.metricsService.findNumericStats(metricIds, p.getTimeRange().getStart(), p.getTimeRange().getEnd(), p.getBucketConfig().getBuckets(), p.getPercentiles(), stacked.booleanValue(), false))).flatMap(Observable::from).skipWhile(bucket -> Boolean.TRUE.equals(fromEarliest) && bucket.isEmpty()).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.error((Throwable)t)));
    }

    @POST
    @Path(value="/stats/query")
    @ApiOperation(value="Find stats for multiple metrics. These metrics are aggregated into a single statistics series.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric data."), @ApiResponse(code=204, message="Query was successful, but no data was found."), @ApiResponse(code=400, message="Either tags or metric ids is required but not both. Either the buckets or the bucketDuration parameter is required but not both.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void getStats(@Suspended AsyncResponse asyncResponse, @ApiParam(required=true, value="Query parameters that minimally must include a list of metric ids. The standard start, end, order, and limit query parameters are supported as well.") AggregatedStatsQueryRequest query) {
        this.findMetricsByNameOrTag(query.getMetrics(), query.getTags(), MetricType.GAUGE).toList().flatMap(metricIds -> TimeAndBucketParams.deferredBuilder((String)query.getStart(), (String)query.getEnd()).fromEarliest(query.getFromEarliest(), metricIds, (arg_0, arg_1, arg_2, arg_3) -> ((GaugeHandler)this).findTimeRange(arg_0, arg_1, arg_2, arg_3)).bucketConfig(query.getBuckets(), query.getBucketDuration()).percentiles(query.getPercentiles()).toObservable().flatMap(p -> this.metricsService.findNumericStats(metricIds, p.getTimeRange().getStart(), p.getTimeRange().getEnd(), p.getBucketConfig().getBuckets(), p.getPercentiles(), query.isStacked(), false))).flatMap(Observable::from).skipWhile(bucket -> Boolean.TRUE.equals(query.getFromEarliest()) && bucket.isEmpty()).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.error((Throwable)t)));
    }

    @GET
    @Path(value="/{id}/stats/tags/{tags}")
    @ApiOperation(value="Fetches data points and groups them into buckets based on one or more tag filters. The data points in each bucket are then transformed into aggregated (i.e., bucket) data points.", response=TaggedBucketPoint.class, responseContainer="Map")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric data."), @ApiResponse(code=204, message="No metric data was found."), @ApiResponse(code=400, message="Tags are invalid", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void getMetricStatsByTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") String start, @ApiParam(value="Defaults to now") @QueryParam(value="end") String end, @ApiParam(value="Percentiles to calculate") @QueryParam(value="percentiles") Percentiles percentiles, @ApiParam(value="Tags") @PathParam(value="tags") Tags tags) {
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem())));
            return;
        }
        MetricId metricId = new MetricId(this.getTenant(), MetricType.GAUGE, id);
        if (percentiles == null) {
            percentiles = new Percentiles(Collections.emptyList());
        }
        this.metricsService.findGaugeStats(metricId, tags.getTags(), timeRange.getStart(), timeRange.getEnd(), percentiles.getPercentiles()).map(ApiUtils::mapToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }

    @Deprecated
    @GET
    @Path(value="/data")
    @ApiOperation(value="Deprecated. Please use /stats endpoint.", response=NumericBucketPoint.class, responseContainer="List")
    public void deprecatedFindData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") String start, @ApiParam(value="Defaults to now") @QueryParam(value="end") String end, @ApiParam(value="Total number of buckets") @QueryParam(value="buckets") Integer bucketsCount, @ApiParam(value="Bucket duration") @QueryParam(value="bucketDuration") Duration bucketDuration, @ApiParam(value="Percentiles to calculate") @QueryParam(value="percentiles") Percentiles percentiles, @ApiParam(value="List of tags filters") @QueryParam(value="tags") String tags, @ApiParam(value="List of metric names") @QueryParam(value="metrics") List<String> metricNames, @ApiParam(value="Downsample method (if true then sum of stacked individual stats; defaults to false)") @DefaultValue(value="false") @QueryParam(value="stacked") Boolean stacked) {
        this.getStats(asyncResponse, start, end, null, bucketsCount, bucketDuration, percentiles, tags, metricNames, stacked);
    }

    @GET
    @Path(value="/{id}/periods")
    @ApiOperation(value="Find condition periods.", notes="Retrieve periods for which the condition holds true for each consecutive data point.", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched periods."), @ApiResponse(code=204, message="No data was found."), @ApiResponse(code=400, message="Missing or invalid query parameters", response=ApiError.class)})
    public void getMetricPeriods(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") String start, @ApiParam(value="Defaults to now") @QueryParam(value="end") String end, @ApiParam(value="A threshold against which values are compared", required=true) @QueryParam(value="threshold") double threshold, @ApiParam(value="A comparison operation to perform between values and the threshold.", required=true, allowableValues="ge, gte, lt, lte, eq, neq") @QueryParam(value="op") String operator) {
        Predicate<Double> predicate;
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem())));
            return;
        }
        switch (operator) {
            case "lt": {
                predicate = d -> d < threshold;
                break;
            }
            case "lte": {
                predicate = d -> d <= threshold;
                break;
            }
            case "eq": {
                predicate = d -> d == threshold;
                break;
            }
            case "neq": {
                predicate = d -> d != threshold;
                break;
            }
            case "gt": {
                predicate = d -> d > threshold;
                break;
            }
            case "gte": {
                predicate = d -> d >= threshold;
                break;
            }
            default: {
                predicate = null;
            }
        }
        if (predicate == null) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Invalid value for op parameter. Supported values are lt, lte, eq, gt, gte.")));
        } else {
            MetricId metricId = new MetricId(this.getTenant(), MetricType.GAUGE, id);
            this.metricsService.getPeriods(metricId, predicate, timeRange.getStart(), timeRange.getEnd()).map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
        }
    }

    @GET
    @Path(value="/{id}/rate")
    @ApiOperation(value="Retrieve gauge rate data points.", response=DataPoint.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric data."), @ApiResponse(code=204, message="No metric data was found."), @ApiResponse(code=400, message="Time range is invalid.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void getMetricRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") String start, @ApiParam(value="Defaults to now") @QueryParam(value="end") String end, @ApiParam(value="Use data from earliest received, subject to retention period") @QueryParam(value="fromEarliest") Boolean fromEarliest, @ApiParam(value="Limit the number of data points returned") @QueryParam(value="limit") Integer limit, @ApiParam(value="Data point sort order, based on timestamp") @QueryParam(value="order") Order order) {
        MetricId metricId = new MetricId(this.getTenant(), MetricType.GAUGE, id);
        TimeAndSortParams.deferredBuilder((String)start, (String)end).fromEarliest(fromEarliest, metricId, (arg_0, arg_1, arg_2, arg_3) -> ((GaugeHandler)this).findTimeRange(arg_0, arg_1, arg_2, arg_3)).sortOptions(limit, order).toObservable().flatMap(p -> this.metricsService.findRateData(metricId, p.getTimeRange().getStart(), p.getTimeRange().getEnd(), p.getLimit(), p.getOrder())).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.error((Throwable)t)));
    }

    @GET
    @Path(value="/{id}/rate/stats")
    @ApiOperation(value="Retrieve stats for gauge rate data points.", notes="The time range between start and end will be divided in buckets of equal duration, and metric statistics will be computed for each bucket.", response=NumericBucketPoint.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric data."), @ApiResponse(code=204, message="No metric data was found."), @ApiResponse(code=400, message="buckets or bucketDuration parameter is invalid, or both are used.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void getMetricRateStats(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") String start, @ApiParam(value="Defaults to now") @QueryParam(value="end") String end, @ApiParam(value="Use data from earliest received, subject to retention period") @QueryParam(value="fromEarliest") Boolean fromEarliest, @ApiParam(value="Total number of buckets") @QueryParam(value="buckets") Integer bucketsCount, @ApiParam(value="Bucket duration") @QueryParam(value="bucketDuration") Duration bucketDuration, @ApiParam(value="Percentiles to calculate") @QueryParam(value="percentiles") Percentiles percentiles) {
        MetricId metricId = new MetricId(this.getTenant(), MetricType.GAUGE, id);
        TimeAndBucketParams.deferredBuilder((String)start, (String)end).fromEarliest(fromEarliest, metricId, (arg_0, arg_1, arg_2, arg_3) -> ((GaugeHandler)this).findTimeRange(arg_0, arg_1, arg_2, arg_3)).bucketConfig(bucketsCount, bucketDuration).percentiles(percentiles).toObservable().flatMap(p -> this.metricsService.findRateStats(metricId, p.getBucketConfig(), p.getPercentiles())).flatMap(Observable::from).skipWhile(bucket -> Boolean.TRUE.equals(fromEarliest) && bucket.isEmpty()).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.error((Throwable)t)));
    }

    @GET
    @Path(value="/rate/stats")
    @ApiOperation(value="Fetches data points from one or more metrics that are determined using either a tags filter or a list of metric names. The time range between start and end is divided into buckets of equal size (i.e., duration) using either the buckets or bucketDuration parameter. Functions are applied to the data points in each bucket to produce statistics or aggregated metrics.", response=NumericBucketPoint.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric data."), @ApiResponse(code=204, message="No metric data was found."), @ApiResponse(code=400, message="The tags parameter is required. Either the buckets or the bucketDuration parameter is required but not both.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void getRateStats(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") String start, @ApiParam(value="Defaults to now") @QueryParam(value="end") String end, @ApiParam(value="Use data from earliest received, subject to retention period") @QueryParam(value="fromEarliest") Boolean fromEarliest, @ApiParam(value="Total number of buckets") @QueryParam(value="buckets") Integer bucketsCount, @ApiParam(value="Bucket duration") @QueryParam(value="bucketDuration") Duration bucketDuration, @ApiParam(value="Percentiles to calculate") @QueryParam(value="percentiles") Percentiles percentiles, @ApiParam(value="List of tags filters") @QueryParam(value="tags") String tags, @ApiParam(value="List of metric names") @QueryParam(value="metrics") List<String> metricNames, @ApiParam(value="Downsample method (if true then sum of stacked individual stats; defaults to false)") @DefaultValue(value="false") @QueryParam(value="stacked") Boolean stacked) {
        this.findMetricsByNameOrTag(metricNames, tags, MetricType.GAUGE).toList().flatMap(metricIds -> TimeAndBucketParams.deferredBuilder((String)start, (String)end).fromEarliest(fromEarliest, metricIds, (arg_0, arg_1, arg_2, arg_3) -> ((GaugeHandler)this).findTimeRange(arg_0, arg_1, arg_2, arg_3)).bucketConfig(bucketsCount, bucketDuration).percentiles(percentiles).toObservable().flatMap(p -> this.metricsService.findNumericStats(metricIds, p.getTimeRange().getStart(), p.getTimeRange().getEnd(), p.getBucketConfig().getBuckets(), p.getPercentiles(), stacked.booleanValue(), true))).flatMap(Observable::from).skipWhile(bucket -> Boolean.TRUE.equals(fromEarliest) && bucket.isEmpty()).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.error((Throwable)t)));
    }
}

