/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wsat.client;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices11.ServiceRegistry;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.util.PrivilegedMapBuilderFactory;
import com.arjuna.webservices11.util.PrivilegedServiceRegistryFactory;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsaddr.EndpointHelper;
import com.arjuna.webservices11.wsaddr.NativeEndpointReference;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsat.client.WSATClient;
import java.io.IOException;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.ws.api.addressing.MAP;
import org.jboss.ws.api.addressing.MAPBuilder;
import org.jboss.ws.api.addressing.MAPEndpoint;
import org.oasis_open.docs.ws_tx.wsat._2006._06.CompletionInitiatorPortType;
import org.oasis_open.docs.ws_tx.wsat._2006._06.Notification;
import org.xmlsoap.schemas.soap.envelope.Fault;

public class CompletionInitiatorClient {
    private static final CompletionInitiatorClient CLIENT = new CompletionInitiatorClient();
    private String committedAction = null;
    private String abortedAction = null;
    private String faultAction = null;
    private MAPEndpoint completionCoordinator;
    private MAPEndpoint secureCompletionCoordinator;

    private CompletionInitiatorClient() {
        MAPBuilder builder = PrivilegedMapBuilderFactory.getInstance().getBuilderInstance();
        this.committedAction = "http://docs.oasis-open.org/ws-tx/wsat/2006/06/Committed";
        this.abortedAction = "http://docs.oasis-open.org/ws-tx/wsat/2006/06/Aborted";
        this.faultAction = "http://docs.oasis-open.org/ws-tx/wsat/2006/06/fault";
        ServiceRegistry serviceRegistry = PrivilegedServiceRegistryFactory.getInstance().getServiceRegistry();
        String completionCoordinatorURIString = serviceRegistry.getServiceURI("CompletionCoordinatorService", false);
        String secureCompletionCoordinatorURIString = serviceRegistry.getServiceURI("CompletionCoordinatorService", true);
        this.completionCoordinator = builder.newEndpoint(completionCoordinatorURIString);
        this.secureCompletionCoordinator = builder.newEndpoint(secureCompletionCoordinatorURIString);
    }

    public void sendCommitted(W3CEndpointReference participant, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint coordinator = this.getCompletionCoordinator(participant);
        AddressingHelper.installFaultTo(map, coordinator, identifier);
        CompletionInitiatorPortType port = this.getPort(participant, map, this.committedAction);
        Notification commited = new Notification();
        port.committedOperation(commited);
    }

    public void sendAborted(W3CEndpointReference participant, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint coordinator = this.getCompletionCoordinator(participant);
        AddressingHelper.installFaultTo(map, coordinator, identifier);
        CompletionInitiatorPortType port = this.getPort(participant, map, this.abortedAction);
        Notification aborted = new Notification();
        port.abortedOperation(aborted);
    }

    public void sendSoapFault(W3CEndpointReference participant, MAP map, SoapFault soapFault, InstanceIdentifier identifier) throws SoapFault, IOException {
        CompletionInitiatorPortType port = this.getPort(participant, map, this.faultAction);
        soapFault.setAction(this.faultAction);
        Fault fault = ((SoapFault11)soapFault).toFault();
        port.soapFault(fault);
    }

    public void sendSoapFault(MAP map, SoapFault soapFault, InstanceIdentifier identifier) throws SoapFault, IOException {
        CompletionInitiatorPortType port = this.getPort(null, map, this.faultAction);
        soapFault.setAction(this.faultAction);
        Fault fault = ((SoapFault11)soapFault).toFault();
        port.soapFault(fault);
    }

    MAPEndpoint getCompletionCoordinator(W3CEndpointReference participant) {
        NativeEndpointReference nativeRef = EndpointHelper.transform(NativeEndpointReference.class, (EndpointReference)participant);
        String address = nativeRef.getAddress();
        if (address.startsWith("https")) {
            return this.secureCompletionCoordinator;
        }
        return this.completionCoordinator;
    }

    public static CompletionInitiatorClient getClient() {
        return CLIENT;
    }

    private CompletionInitiatorPortType getPort(W3CEndpointReference participant, MAP map, String action) {
        AddressingHelper.installNoneReplyTo(map);
        if (participant == null) {
            return WSATClient.getCompletionInitiatorPort(action, map);
        }
        return WSATClient.getCompletionInitiatorPort(participant, action, map);
    }
}

