/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.spi;

import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.hibernate.search.indexes.serialization.spi.SerializableStore;

public class LuceneNumericFieldContext {
    private final FieldType field;
    private final String fieldName;
    private final float fieldBoost;

    public LuceneNumericFieldContext(FieldType field, String fieldName, float fieldBoost) {
        this.field = field;
        this.fieldName = fieldName;
        this.fieldBoost = fieldBoost;
    }

    public String getName() {
        return this.fieldName;
    }

    public int getPrecisionStep() {
        return this.field.numericPrecisionStep();
    }

    public SerializableStore getStore() {
        return this.field.stored() ? SerializableStore.YES : SerializableStore.NO;
    }

    public boolean isIndexed() {
        return this.field.indexOptions() != IndexOptions.NONE;
    }

    public float getBoost() {
        return this.fieldBoost;
    }

    public boolean getOmitNorms() {
        return this.field.omitNorms();
    }

    public boolean getOmitTermFreqAndPositions() {
        return this.field.indexOptions() == IndexOptions.DOCS;
    }
}

