/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import org.infinispan.Cache;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;
import org.wildfly.clustering.server.group.CacheGroup;
import org.wildfly.clustering.server.group.CacheGroupConfiguration;
import org.wildfly.clustering.server.group.CacheGroupServiceNameProvider;
import org.wildfly.clustering.server.group.InfinispanNodeFactory;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.CacheGroupServiceName;

public class CacheGroupBuilder
extends CacheGroupServiceNameProvider
implements Builder<Group>,
Service<Group>,
CacheGroupConfiguration {
    private final InjectedValue<Cache> cache = new InjectedValue();
    private final InjectedValue<InfinispanNodeFactory> factory = new InjectedValue();
    private volatile CacheGroup group;

    public CacheGroupBuilder(String containerName, String cacheName) {
        super(containerName, cacheName);
    }

    public ServiceBuilder<Group> build(ServiceTarget target) {
        return target.addService(this.getServiceName(), (Service)this).addDependency(CacheServiceName.CACHE.getServiceName(this.containerName, this.cacheName), Cache.class, this.cache).addDependency(CacheGroupServiceName.NODE_FACTORY.getServiceName(this.containerName, this.cacheName), InfinispanNodeFactory.class, this.factory).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public Cache<?, ?> getCache() {
        return (Cache)this.cache.getValue();
    }

    public Group getValue() {
        return this.group;
    }

    public void start(StartContext context) {
        this.group = new CacheGroup(this);
    }

    public void stop(StopContext context) {
        this.group.close();
        this.group = null;
    }

    @Override
    public InfinispanNodeFactory getNodeFactory() {
        return (InfinispanNodeFactory)this.factory.getValue();
    }
}

