/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso;

import org.infinispan.Cache;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.spi.service.CacheBuilder;
import org.wildfly.clustering.infinispan.spi.service.CacheContainerServiceName;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSOManagerFactory;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSOManagerFactoryConfiguration;
import org.wildfly.clustering.web.sso.SSOManagerFactory;

public class InfinispanSSOManagerFactoryBuilder<A, D>
implements Builder<SSOManagerFactory<A, D, TransactionBatch>>,
Value<SSOManagerFactory<A, D, TransactionBatch>>,
InfinispanSSOManagerFactoryConfiguration {
    public static final String DEFAULT_CACHE_CONTAINER = "web";
    private final String host;
    private final InjectedValue<Cache> cache = new InjectedValue();
    private final InjectedValue<KeyAffinityServiceFactory> affinityFactory = new InjectedValue();
    private final InjectedValue<ModuleLoader> loader = new InjectedValue();

    public InfinispanSSOManagerFactoryBuilder(String host) {
        this.host = host;
    }

    public ServiceName getServiceName() {
        return ServiceName.JBOSS.append(new String[]{"clustering", "sso", this.host});
    }

    public ServiceBuilder<SSOManagerFactory<A, D, TransactionBatch>> build(ServiceTarget target) {
        String containerName = DEFAULT_CACHE_CONTAINER;
        String templateCacheName = "default";
        String cacheName = this.host;
        new TemplateConfigurationBuilder(containerName, cacheName, templateCacheName).build(target).install();
        new CacheBuilder(containerName, cacheName).build(target).install();
        return target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(CacheServiceName.CACHE.getServiceName(containerName, cacheName), Cache.class, this.cache).addDependency(CacheContainerServiceName.AFFINITY.getServiceName(containerName), KeyAffinityServiceFactory.class, this.affinityFactory).addDependency(ServiceName.JBOSS.append(new String[]{"as", "service-module-loader"}), ModuleLoader.class, this.loader);
    }

    public SSOManagerFactory<A, D, TransactionBatch> getValue() {
        return new InfinispanSSOManagerFactory(this);
    }

    @Override
    public <K, V> Cache<K, V> getCache() {
        return (Cache)this.cache.getValue();
    }

    @Override
    public KeyAffinityServiceFactory getKeyAffinityServiceFactory() {
        return (KeyAffinityServiceFactory)this.affinityFactory.getValue();
    }

    @Override
    public ModuleLoader getModuleLoader() {
        return (ModuleLoader)this.loader.getValue();
    }
}

