/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.xts.recovery.coordinator;

import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jbossts.xts.environment.RecoveryEnvironmentBean;
import org.jboss.jbossts.xts.environment.XTSPropertyManager;
import org.jboss.jbossts.xts.recovery.XTSRecoveryModule;
import org.jboss.jbossts.xts.recovery.logging.RecoveryLogger;

public class CoordinatorRecoveryInitialisation {
    private static List<XTSRecoveryModule> recoveryModules = new ArrayList<XTSRecoveryModule>();
    private static boolean initialised = false;

    public static void startup() {
        if (initialised) {
            return;
        }
        RecoveryEnvironmentBean recoveryEnvironmentBean = XTSPropertyManager.getRecoveryEnvironmentBean();
        List<String> modules = recoveryEnvironmentBean.getCoordinatorRecoveryModules();
        for (String className : modules) {
            Class<?> clazz = null;
            try {
                clazz = CoordinatorRecoveryInitialisation.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                RecoveryLogger.i18NLogger.error_recovery_coordinator_CoordinatorRecoveryInitialisation_1(className, cnfe);
                continue;
            }
            if (!RecoveryModule.class.isAssignableFrom(clazz)) {
                RecoveryLogger.i18NLogger.error_recovery_coordinator_CoordinatorRecoveryInitialisation_2(className);
                continue;
            }
            try {
                XTSRecoveryModule module = (XTSRecoveryModule)clazz.newInstance();
                module.install();
                RecoveryManager.manager().addModule((RecoveryModule)module);
                recoveryModules.add(module);
            }
            catch (InstantiationException ie) {
                RecoveryLogger.i18NLogger.error_recovery_coordinator_CoordinatorRecoveryInitialisation_3(className, ie);
            }
            catch (IllegalAccessException iae) {
                RecoveryLogger.i18NLogger.error_recovery_coordinator_CoordinatorRecoveryInitialisation_4(className, iae);
            }
        }
        initialised = true;
    }

    public static void shutdown() {
        if (!initialised) {
            return;
        }
        for (XTSRecoveryModule module : recoveryModules) {
            RecoveryManager.manager().removeModule((RecoveryModule)module, true);
            module.uninstall();
        }
        recoveryModules.clear();
        initialised = false;
    }
}

