/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.singleton.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.SingletonPolicy;
import org.wildfly.clustering.singleton.SingletonServiceBuilderFactory;
import org.wildfly.clustering.singleton.SingletonServiceName;
import org.wildfly.extension.clustering.singleton.ElectionPolicyServiceNameProvider;
import org.wildfly.extension.clustering.singleton.SingletonPolicyResourceDefinition;

public class SingletonPolicyBuilder
implements ResourceServiceBuilder<SingletonPolicy>,
SingletonPolicy {
    private final InjectedValue<SingletonServiceBuilderFactory> factory = new InjectedValue();
    private final InjectedValue<SingletonElectionPolicy> policy = new InjectedValue();
    private final String name;
    private volatile String containerName;
    private volatile String cacheName;
    private volatile int quorum;

    public SingletonPolicyBuilder(String name) {
        this.name = name;
    }

    public ServiceName getServiceName() {
        return this.name != null ? SingletonPolicyResourceDefinition.Capability.POLICY.getDefinition().getCapabilityServiceName(this.name) : SingletonPolicyResourceDefinition.Capability.POLICY.getDefinition().getCapabilityServiceName();
    }

    public ServiceBuilder<SingletonPolicy> build(ServiceTarget target) {
        return target.addService(this.getServiceName(), (Service)new ValueService((Value)new ImmediateValue((Object)this))).addDependency(SingletonServiceName.BUILDER.getServiceName(this.containerName, this.cacheName), SingletonServiceBuilderFactory.class, this.factory).addDependency(new ElectionPolicyServiceNameProvider(this.name).getServiceName(), SingletonElectionPolicy.class, this.policy);
    }

    public Builder<SingletonPolicy> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.containerName = SingletonPolicyResourceDefinition.Attribute.CACHE_CONTAINER.getDefinition().resolveModelAttribute(context, model).asString();
        this.cacheName = SingletonPolicyResourceDefinition.Attribute.CACHE.getDefinition().resolveModelAttribute(context, model).asString();
        this.quorum = SingletonPolicyResourceDefinition.Attribute.QUORUM.getDefinition().resolveModelAttribute(context, model).asInt();
        return this;
    }

    public <T> Builder<T> createSingletonServiceBuilder(ServiceName name, Service<T> service) {
        return ((SingletonServiceBuilderFactory)this.factory.getValue()).createSingletonServiceBuilder(name, service).electionPolicy((SingletonElectionPolicy)this.policy.getValue()).requireQuorum(this.quorum);
    }
}

