/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.common.properties.query;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.picketlink.common.properties.query.PropertyCriteria;

public class TypedPropertyCriteria
implements PropertyCriteria {
    private final Class<?> propertyClass;
    private final MatchOption matchOption;

    public TypedPropertyCriteria(Class<?> propertyClass) {
        this(propertyClass, null);
    }

    public TypedPropertyCriteria(Class<?> propertyClass, MatchOption matchOption) {
        if (propertyClass == null) {
            throw new IllegalArgumentException("Property class can not be null.");
        }
        this.propertyClass = propertyClass;
        this.matchOption = matchOption;
    }

    @Override
    public boolean fieldMatches(Field f) {
        return this.match(f.getType());
    }

    @Override
    public boolean methodMatches(Method m) {
        return this.match(m.getReturnType());
    }

    private boolean match(Class<?> type) {
        if (this.propertyClass.equals(type)) {
            return true;
        }
        boolean matchSubType = this.propertyClass.isAssignableFrom(type);
        if (MatchOption.SUB_TYPE == this.matchOption) {
            return matchSubType;
        }
        boolean matchSuperType = type.isAssignableFrom(this.propertyClass);
        if (MatchOption.SUPER_TYPE == this.matchOption) {
            return matchSuperType;
        }
        if (MatchOption.ALL == this.matchOption) {
            return matchSubType || matchSuperType;
        }
        return false;
    }

    public static enum MatchOption {
        SUB_TYPE,
        SUPER_TYPE,
        ALL;

    }
}

