/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.dto;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

public class XmlUtil {
    private static final XMLInputFactory factory = XMLInputFactory.newInstance();

    public static <T> T decode(Class<T> clazz, File configuration) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.apache.activemq.artemis.dto");
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        sf.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
        InputStream xsdStream = XmlUtil.class.getClassLoader().getResourceAsStream("org.apache.activemq/dto/activemq.xsd");
        StreamSource xsdSource = new StreamSource(xsdStream);
        Schema schema = sf.newSchema(xsdSource);
        unmarshaller.setSchema(schema);
        XMLStreamReader reader = factory.createXMLStreamReader(new FileInputStream(configuration));
        Properties props = System.getProperties();
        if (props != null) {
            reader = new PropertiesFilter(reader, props);
        }
        return clazz.cast(unmarshaller.unmarshal(reader));
    }

    static class PropertiesFilter
    extends StreamReaderDelegate {
        static final Pattern pattern = Pattern.compile("\\$\\{([^\\}]+)\\}");
        private final Properties props;

        public PropertiesFilter(XMLStreamReader parent, Properties props) {
            super(parent);
            this.props = props;
        }

        @Override
        public String getAttributeValue(int index) {
            return this.filter(super.getAttributeValue(index));
        }

        public String filter(String str) {
            Matcher matcher;
            int start = 0;
            while ((matcher = pattern.matcher(str)).find(start)) {
                String group = matcher.group(1);
                String property = this.props.getProperty(group);
                if (property != null) {
                    str = matcher.replaceFirst(Matcher.quoteReplacement(property));
                    continue;
                }
                start = matcher.end();
            }
            return str;
        }
    }
}

