/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.util.Arrays;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.context.InvocationContext;

public class EndInvalidationCommand
extends BaseRpcCommand {
    private Object[] keys;
    private Object sessionTransactionId;
    private PutFromLoadValidator putFromLoadValidator;

    public EndInvalidationCommand(String cacheName) {
        this(cacheName, null, null);
    }

    public EndInvalidationCommand(String cacheName, Object[] keys, Object sessionTransactionId) {
        super(cacheName);
        this.keys = keys;
        this.sessionTransactionId = sessionTransactionId;
    }

    public Object perform(InvocationContext ctx) throws Throwable {
        for (Object key : this.keys) {
            this.putFromLoadValidator.endInvalidatingKey(this.sessionTransactionId, key);
        }
        return null;
    }

    public byte getCommandId() {
        return 121;
    }

    public Object[] getParameters() {
        return new Object[]{this.keys, this.sessionTransactionId};
    }

    public void setParameters(int commandId, Object[] parameters) {
        this.keys = (Object[])parameters[0];
        this.sessionTransactionId = parameters[1];
    }

    public boolean isReturnValueExpected() {
        return false;
    }

    public boolean canBlock() {
        return true;
    }

    public void setPutFromLoadValidator(PutFromLoadValidator putFromLoadValidator) {
        this.putFromLoadValidator = putFromLoadValidator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EndInvalidationCommand)) {
            return false;
        }
        EndInvalidationCommand that = (EndInvalidationCommand)((Object)o);
        if (this.cacheName == null ? this.cacheName != null : !this.cacheName.equals(that.cacheName)) {
            return false;
        }
        if (!Arrays.equals(this.keys, that.keys)) {
            return false;
        }
        return !(this.sessionTransactionId == null ? that.sessionTransactionId != null : !this.sessionTransactionId.equals(that.sessionTransactionId));
    }

    public int hashCode() {
        int result = this.cacheName != null ? this.cacheName.hashCode() : 0;
        result = 31 * result + (this.keys != null ? Arrays.hashCode(this.keys) : 0);
        result = 31 * result + (this.sessionTransactionId != null ? this.sessionTransactionId.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EndInvalidationCommand{");
        sb.append("cacheName=").append(this.cacheName);
        sb.append(", keys=").append(Arrays.toString(this.keys));
        sb.append(", sessionTransactionId=").append(this.sessionTransactionId);
        sb.append('}');
        return sb.toString();
    }
}

