/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.selector.filter;

import org.apache.activemq.artemis.selector.filter.BooleanExpression;
import org.apache.activemq.artemis.selector.filter.ConstantExpression;
import org.apache.activemq.artemis.selector.filter.FilterException;
import org.apache.activemq.artemis.selector.filter.Filterable;
import org.apache.activemq.artemis.selector.filter.XalanXPathEvaluator;

public final class XPathExpression
implements BooleanExpression {
    public static XPathEvaluatorFactory XPATH_EVALUATOR_FACTORY = null;
    private final String xpath;
    private final XPathEvaluator evaluator;

    XPathExpression(String xpath) {
        if (XPATH_EVALUATOR_FACTORY == null) {
            throw new IllegalArgumentException("XPATH support not enabled.");
        }
        this.xpath = xpath;
        this.evaluator = XPATH_EVALUATOR_FACTORY.create(xpath);
    }

    @Override
    public Object evaluate(Filterable message) throws FilterException {
        return this.evaluator.evaluate(message) ? Boolean.TRUE : Boolean.FALSE;
    }

    public String toString() {
        return "XPATH " + ConstantExpression.encodeString(this.xpath);
    }

    @Override
    public boolean matches(Filterable message) throws FilterException {
        Object object = this.evaluate(message);
        return object != null && object == Boolean.TRUE;
    }

    static {
        new XalanXPathEvaluator("//root").evaluate("<root></root>");
        try {
            XPATH_EVALUATOR_FACTORY = new XPathEvaluatorFactory(){

                @Override
                public XPathEvaluator create(String xpath) {
                    return new XalanXPathEvaluator(xpath);
                }
            };
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static interface XPathEvaluator {
        public boolean evaluate(Filterable var1) throws FilterException;
    }

    public static interface XPathEvaluatorFactory {
        public XPathEvaluator create(String var1);
    }
}

