/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.mod_cluster.CustomLoadMetricDefinition;
import org.wildfly.extension.mod_cluster.DynamicLoadProviderDefinition;
import org.wildfly.extension.mod_cluster.ModClusterConfigResourceDefinition;
import org.wildfly.extension.mod_cluster.ModClusterSubsystemResourceDefinition;

public class ModClusterRemoveCustomMetric
implements OperationStepHandler {
    static final ModClusterRemoveCustomMetric INSTANCE = new ModClusterRemoveCustomMetric();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress parent = PathAddress.pathAddress((PathElement[])new PathElement[]{ModClusterSubsystemResourceDefinition.PATH, ModClusterConfigResourceDefinition.PATH, DynamicLoadProviderDefinition.PATH});
        String clazz = CustomLoadMetricDefinition.CLASS.resolveModelAttribute(context, operation).asString();
        String name = this.getMetricName(context, clazz);
        if (name == null) {
            context.setRollbackOnly();
        } else {
            ModelNode targetOperation = Util.createRemoveOperation((PathAddress)parent.append(new PathElement[]{PathElement.pathElement((String)CustomLoadMetricDefinition.PATH.getKey(), (String)name)}));
            context.addStep(targetOperation, (OperationStepHandler)new ReloadRequiredRemoveStepHandler(), OperationContext.Stage.MODEL, true);
        }
        context.stepCompleted();
    }

    private String getMetricName(OperationContext context, String type) {
        Set metrics = context.readResource(PathAddress.pathAddress((PathElement[])new PathElement[]{DynamicLoadProviderDefinition.PATH})).getChildrenNames("custom-load-metric");
        for (String name : metrics) {
            if (!name.equals(type)) continue;
            return name;
        }
        return null;
    }
}

