/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.mtom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.basic.Base64Type;
import org.apache.cxf.aegis.type.mtom.AttachmentUtil;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Attachment;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.constants.Constants;
import org.w3c.dom.Attr;

public abstract class AbstractXOPType
extends AegisType {
    public static final String XOP_NS = "http://www.w3.org/2004/08/xop/include";
    public static final String XML_MIME_NS = "http://www.w3.org/2005/05/xmlmime";
    public static final String XML_MIME_ATTR_LOCAL_NAME = "expectedContentTypes";
    public static final QName XOP_INCLUDE = new QName("http://www.w3.org/2004/08/xop/include", "Include");
    public static final QName XML_MIME_CONTENT_TYPE = new QName("http://www.w3.org/2005/05/xmlmime", "contentType");
    public static final QName XOP_HREF = new QName("href");
    public static final QName XML_MIME_BASE64 = new QName("http://www.w3.org/2005/05/xmlmime", "base64Binary", "xmime");
    private String expectedContentTypes;
    private Base64Type fallbackDelegate;
    private boolean useXmimeBinaryType;

    public AbstractXOPType(boolean useXmimeBinaryType, String expectedContentTypes) {
        this.expectedContentTypes = expectedContentTypes;
        this.useXmimeBinaryType = useXmimeBinaryType;
        this.fallbackDelegate = new Base64Type(this);
        if (useXmimeBinaryType) {
            this.setSchemaType(XML_MIME_BASE64);
        } else {
            this.setSchemaType(Constants.XSD_BASE64);
        }
    }

    public Object readMtoM(MessageReader reader, Context context) throws DatabindingException {
        Object o = null;
        while (reader.hasMoreElementReaders()) {
            MessageReader child = reader.getNextElementReader();
            if (child.getName().equals(XOP_INCLUDE)) {
                MessageReader mimeReader = child.getAttributeReader(XOP_HREF);
                String type = mimeReader.getValue().trim();
                o = this.readInclude(type, child, context);
            }
            child.readToEnd();
        }
        return o;
    }

    @Override
    public Object readObject(MessageReader reader, Context context) throws DatabindingException {
        XMLStreamReader xreader = reader.getXMLStreamReader();
        String contentType = xreader.getAttributeValue(XML_MIME_NS, XML_MIME_CONTENT_TYPE.getLocalPart());
        Object thingRead = this.fallbackDelegate.readObject(reader, context);
        if (thingRead.getClass() == new byte[0].getClass()) {
            return this.wrapBytes((byte[])thingRead, contentType);
        }
        return thingRead;
    }

    private Object readInclude(String type, MessageReader reader, Context context) throws DatabindingException {
        String href = reader.getAttributeReader(XOP_HREF).getValue().trim();
        Attachment att = AttachmentUtil.getAttachment(href, context.getAttachments());
        if (att == null) {
            throw new DatabindingException("Could not find the attachment " + href);
        }
        try {
            return this.readAttachment(att, context);
        }
        catch (IOException e) {
            throw new DatabindingException("Could not read attachment", (Throwable)e);
        }
    }

    protected abstract Object readAttachment(Attachment var1, Context var2) throws IOException;

    @Override
    public void writeObject(Object object, MessageWriter writer, Context context) throws DatabindingException {
        String contentType = this.getContentType(object, context);
        if (contentType != null && this.useXmimeBinaryType) {
            MessageWriter ctWriter = writer.getAttributeWriter(XML_MIME_CONTENT_TYPE);
            ctWriter.writeValue(contentType);
        }
        if (!context.isMtomEnabled()) {
            this.fallbackDelegate.writeObject(this.getBytes(object), writer, context);
            return;
        }
        Collection<Attachment> attachments = context.getAttachments();
        if (attachments == null) {
            attachments = new ArrayList<Attachment>();
            context.setAttachments(attachments);
        }
        String id = AttachmentUtil.createContentID(this.getSchemaType().getNamespaceURI());
        Attachment att = this.createAttachment(object, id);
        attachments.add(att);
        MessageWriter include = writer.getElementWriter(XOP_INCLUDE);
        MessageWriter href = include.getAttributeWriter(XOP_HREF);
        href.writeValue("cid:" + id);
        include.close();
    }

    protected abstract Attachment createAttachment(Object var1, String var2);

    protected abstract String getContentType(Object var1, Context var2);

    protected abstract Object wrapBytes(byte[] var1, String var2);

    protected abstract byte[] getBytes(Object var1);

    @Override
    public void addToSchemaElement(XmlSchemaElement schemaElement) {
        if (this.expectedContentTypes != null) {
            HashMap<String, Attr> extAttrMap = new HashMap<String, Attr>();
            Attr theAttr = DOMUtils.createDocument().createAttributeNS(XML_MIME_NS, "xmime");
            theAttr.setNodeValue(this.expectedContentTypes);
            extAttrMap.put("xmime", theAttr);
            schemaElement.addMetaInfo((Object)"EXTERNAL_ATTRIBUTES", extAttrMap);
        }
    }

    @Override
    public boolean usesXmime() {
        return this.useXmimeBinaryType || this.expectedContentTypes != null;
    }
}

