/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.password;

import java.util.regex.Pattern;
import org.jboss.as.domain.management.security.password.PasswordRestriction;
import org.jboss.as.domain.management.security.password.PasswordValidationException;

public class RegexRestriction
implements PasswordRestriction {
    private final String regex;
    private final String requirementsMessage;
    private final String failureMessage;

    public RegexRestriction(String regex, String requirementsMessage, String failureMessage) {
        this.regex = regex;
        this.requirementsMessage = requirementsMessage;
        this.failureMessage = failureMessage;
    }

    @Override
    public String getRequirementMessage() {
        return this.requirementsMessage;
    }

    @Override
    public void validate(String userName, String password) throws PasswordValidationException {
        if (!Pattern.matches(this.regex, password)) {
            throw new PasswordValidationException(this.failureMessage);
        }
    }
}

