/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandHandlerProvider;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.ControllerAddress;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

class ExtensionsLoader {
    private final ModuleLoader moduleLoader;
    private final CommandContext ctx;
    private final CommandRegistry registry;
    private ControllerAddress currentAddress;
    private List<String> loadedCommands = Collections.emptyList();
    private List<String> errors = Collections.emptyList();

    ExtensionsLoader(CommandRegistry registry, CommandContext ctx) throws CommandLineException {
        assert (registry != null) : "command registry is null";
        assert (ctx != null) : "command context is null";
        this.moduleLoader = this.getClass().getClassLoader() instanceof ModuleClassLoader ? ModuleLoader.forClassLoader(this.getClass().getClassLoader()) : null;
        this.ctx = ctx;
        this.registry = registry;
        registry.registerHandler((CommandHandler)new ExtensionCommandsHandler(), false, "extension-commands");
    }

    void resetHandlers() {
        for (String cmd : this.loadedCommands) {
            this.registry.remove(cmd);
        }
        this.currentAddress = null;
        this.errors = Collections.emptyList();
        this.loadedCommands = Collections.emptyList();
    }

    void loadHandlers(ControllerAddress address) throws CommandLineException {
        ModelNode response;
        ModelControllerClient client = this.ctx.getModelControllerClient();
        assert (client != null) : "client is null";
        if (this.moduleLoader == null) {
            this.ctx.printLine("Warning! The CLI is running in a non-modular environment and cannot load commands from management extensions.");
            return;
        }
        if (address != null && this.currentAddress != null && address.equals(this.currentAddress)) {
            return;
        }
        this.resetHandlers();
        this.currentAddress = address;
        ModelNode req = new ModelNode();
        req.get("address").setEmptyList();
        req.get("operation").set("read-children-resources");
        req.get("child-type").set("extension");
        try {
            response = client.execute(req);
        }
        catch (IOException e) {
            throw new CommandLineException("Extensions loader failed to read extensions", e);
        }
        if (!Util.isSuccess(response)) {
            throw new CommandLineException("Extensions loader failed to read extensions: " + Util.getFailureDescription(response));
        }
        ModelNode result = response.get("result");
        if (!result.isDefined()) {
            throw new CommandLineException("Extensions loader failed to read extensions: " + result.asString());
        }
        for (Property ext : result.asPropertyList()) {
            ModelNode module = ext.getValue().get("module");
            if (!module.isDefined()) {
                this.addError("Extension " + ext.getName() + " is missing module attribute");
                continue;
            }
            ModuleIdentifier moduleId = ModuleIdentifier.create(module.asString());
            try {
                ModuleClassLoader cl = this.moduleLoader.loadModule(moduleId).getClassLoader();
                ServiceLoader<CommandHandlerProvider> loader = ServiceLoader.load(CommandHandlerProvider.class, cl);
                for (CommandHandlerProvider provider : loader) {
                    try {
                        this.registry.registerHandler(provider.createCommandHandler(this.ctx), provider.isTabComplete(), provider.getNames());
                        this.addCommands(Arrays.asList(provider.getNames()));
                    }
                    catch (CommandRegistry.RegisterHandlerException e) {
                        this.addError(e.getLocalizedMessage());
                        ArrayList<String> addedCommands = new ArrayList<String>(Arrays.asList(provider.getNames()));
                        addedCommands.removeAll(e.getNotAddedNames());
                        this.addCommands(addedCommands);
                    }
                }
            }
            catch (ModuleLoadException e) {
                this.addError("Module " + module.asString() + " from extension " + ext.getName() + " available on the server couldn't be loaded locally: " + e.getLocalizedMessage());
            }
        }
        if (!this.errors.isEmpty()) {
            this.ctx.printLine("Warning! There were errors trying to load extensions. For more details, please, execute 'extension-commands --errors'");
        }
    }

    private void addCommands(List<String> names) {
        if (this.loadedCommands.isEmpty()) {
            this.loadedCommands = new ArrayList<String>();
        }
        this.loadedCommands.addAll(names);
    }

    private void addError(String msg) {
        switch (this.errors.size()) {
            case 0: {
                this.errors = Collections.singletonList(msg);
                break;
            }
            case 1: {
                this.errors = new ArrayList<String>(this.errors);
            }
            default: {
                this.errors.add(msg);
            }
        }
    }

    class ExtensionCommandsHandler
    extends CommandHandlerWithHelp {
        private static final String NAME = "extension-commands";
        private final ArgumentWithoutValue errorsArg;

        ExtensionCommandsHandler() {
            super(NAME);
            this.errorsArg = new ArgumentWithoutValue(this, "--errors");
        }

        @Override
        protected void doHandle(CommandContext ctx) throws CommandLineException {
            if (this.errorsArg.isPresent(ctx.getParsedCommandLine()) && !ExtensionsLoader.this.errors.isEmpty()) {
                StringBuilder buf = new StringBuilder();
                buf.append("The following problems were encountered while looking for additional commands in extensions:\n");
                for (int i = 0; i < ExtensionsLoader.this.errors.size(); ++i) {
                    String error = (String)ExtensionsLoader.this.errors.get(i);
                    buf.append(i + 1).append(") ").append(error).append(Util.LINE_SEPARATOR);
                }
                ctx.printLine(buf.toString());
            }
        }
    }
}

