/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.service;

import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl;
import org.jboss.as.ee.concurrent.service.EEConcurrentAbstractService;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ManagedThreadFactoryService
extends EEConcurrentAbstractService<ManagedThreadFactoryImpl> {
    private volatile ManagedThreadFactoryImpl managedThreadFactory;
    private final String name;
    private final InjectedValue<ContextServiceImpl> contextService;
    private final int priority;

    public ManagedThreadFactoryService(String name, String jndiName, int priority) {
        super(jndiName);
        this.name = name;
        this.contextService = new InjectedValue();
        this.priority = priority;
    }

    @Override
    void startValue(StartContext context) throws StartException {
        String threadFactoryName = "EE-ManagedThreadFactory-" + this.name;
        this.managedThreadFactory = new ManagedThreadFactoryImpl(threadFactoryName, (ContextServiceImpl)this.contextService.getOptionalValue(), this.priority);
    }

    @Override
    void stopValue(StopContext context) {
        this.managedThreadFactory.stop();
        this.managedThreadFactory = null;
    }

    public ManagedThreadFactoryImpl getValue() throws IllegalStateException {
        if (this.managedThreadFactory == null) {
            throw EeLogger.ROOT_LOGGER.concurrentServiceValueUninitialized();
        }
        return this.managedThreadFactory;
    }

    public Injector<ContextServiceImpl> getContextServiceInjector() {
        return this.contextService;
    }
}

