/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.spi.service.CacheBuilder;
import org.wildfly.clustering.infinispan.spi.service.CacheContainerServiceName;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationBuilder;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.service.AliasServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.CacheGroupServiceName;
import org.wildfly.clustering.spi.GroupServiceName;
import org.wildfly.clustering.web.infinispan.session.InfinispanRouteLocatorBuilder;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;

public class InfinispanSessionManagerFactoryBuilder
implements Builder<SessionManagerFactory<TransactionBatch>>,
Value<SessionManagerFactory<TransactionBatch>>,
InfinispanSessionManagerFactoryConfiguration {
    public static final String DEFAULT_CACHE_CONTAINER = "web";
    private final SessionManagerFactoryConfiguration configuration;
    private final InjectedValue<Cache> cache = new InjectedValue();
    private final InjectedValue<KeyAffinityServiceFactory> affinityFactory = new InjectedValue();
    private final InjectedValue<CommandDispatcherFactory> dispatcherFactory = new InjectedValue();
    private final InjectedValue<NodeFactory> nodeFactory = new InjectedValue();

    private static ServiceName getCacheServiceName(String cacheName) {
        ServiceName serviceName;
        ServiceName baseServiceName = CacheContainerServiceName.CACHE_CONTAINER.getServiceName(DEFAULT_CACHE_CONTAINER).getParent();
        if (!baseServiceName.isParentOf(serviceName = ServiceName.parse((String)(cacheName != null ? cacheName : DEFAULT_CACHE_CONTAINER)))) {
            serviceName = baseServiceName.append(serviceName);
        }
        return serviceName.length() < 4 ? serviceName.append(new String[]{"default"}) : serviceName;
    }

    public InfinispanSessionManagerFactoryBuilder(SessionManagerFactoryConfiguration configuration) {
        this.configuration = configuration;
    }

    public ServiceName getServiceName() {
        return ServiceName.JBOSS.append(new String[]{"clustering", DEFAULT_CACHE_CONTAINER, this.configuration.getDeploymentName()});
    }

    public ServiceBuilder<SessionManagerFactory<TransactionBatch>> build(ServiceTarget target) {
        ServiceName templateCacheServiceName = InfinispanSessionManagerFactoryBuilder.getCacheServiceName(this.configuration.getCacheName());
        String templateCacheName = templateCacheServiceName.getSimpleName();
        String containerName = templateCacheServiceName.getParent().getSimpleName();
        String cacheName = this.configuration.getDeploymentName();
        new TemplateConfigurationBuilder(containerName, cacheName, templateCacheName).build(target).install();
        new CacheBuilder(containerName, cacheName).build(target).addAliases(new ServiceName[]{InfinispanRouteLocatorBuilder.getCacheServiceAlias(cacheName)}).install();
        new AliasServiceBuilder(InfinispanRouteLocatorBuilder.getNodeFactoryServiceAlias(cacheName), CacheGroupServiceName.NODE_FACTORY.getServiceName(containerName, "routing"), NodeFactory.class).build(target).install();
        new AliasServiceBuilder(InfinispanRouteLocatorBuilder.getRegistryServiceAlias(cacheName), CacheGroupServiceName.REGISTRY.getServiceName(containerName, "routing"), Registry.class).build(target).install();
        return target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(CacheServiceName.CACHE.getServiceName(containerName, cacheName), Cache.class, this.cache).addDependency(CacheContainerServiceName.AFFINITY.getServiceName(containerName), KeyAffinityServiceFactory.class, this.affinityFactory).addDependency(GroupServiceName.COMMAND_DISPATCHER.getServiceName(containerName), CommandDispatcherFactory.class, this.dispatcherFactory).addDependency(InfinispanRouteLocatorBuilder.getNodeFactoryServiceAlias(cacheName), NodeFactory.class, this.nodeFactory).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public SessionManagerFactory<TransactionBatch> getValue() {
        return new InfinispanSessionManagerFactory(this);
    }

    @Override
    public SessionManagerFactoryConfiguration getSessionManagerFactoryConfiguration() {
        return this.configuration;
    }

    @Override
    public <K, V> Cache<K, V> getCache() {
        return (Cache)this.cache.getValue();
    }

    @Override
    public KeyAffinityServiceFactory getKeyAffinityServiceFactory() {
        return (KeyAffinityServiceFactory)this.affinityFactory.getValue();
    }

    @Override
    public CommandDispatcherFactory getCommandDispatcherFactory() {
        return (CommandDispatcherFactory)this.dispatcherFactory.getValue();
    }

    @Override
    public NodeFactory<Address> getNodeFactory() {
        return (NodeFactory)this.nodeFactory.getValue();
    }
}

