/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.proxy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.interceptor.proxy.InterceptorInvocation;
import org.jboss.weld.interceptor.proxy.InterceptorMethodInvocation;
import org.jboss.weld.interceptor.reader.TargetClassInterceptorMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorClassMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Reflections;

public class InterceptionContext
implements Serializable {
    private static final Set<InterceptionType> CONSTRUCTOR_INTERCEPTION_TYPES = ImmutableSet.of((Object)((Object)InterceptionType.AROUND_CONSTRUCT));
    private static final Set<InterceptionType> METHOD_INTERCEPTION_TYPES = ImmutableSet.of((Object)((Object)InterceptionType.AROUND_INVOKE), (Object)((Object)InterceptionType.AROUND_TIMEOUT), (Object)((Object)InterceptionType.POST_CONSTRUCT), (Object)((Object)InterceptionType.PRE_DESTROY), (Object)((Object)InterceptionType.POST_ACTIVATE), (Object)((Object)InterceptionType.PRE_PASSIVATE), (Object[])new InterceptionType[0]);
    private static final long serialVersionUID = 7500722360133273633L;
    private final transient InterceptionModel interceptionModel;
    private final Map<Class<?>, Object> interceptorInstances;
    private final BeanManagerImpl manager;
    private final SlimAnnotatedType<?> annotatedType;

    public static InterceptionContext forConstructorInterception(InterceptionModel interceptionModel, CreationalContext<?> ctx, BeanManagerImpl manager, SlimAnnotatedType<?> type) {
        return InterceptionContext.of(interceptionModel, ctx, manager, CONSTRUCTOR_INTERCEPTION_TYPES, type);
    }

    public static InterceptionContext forNonConstructorInterception(InterceptionModel interceptionModel, CreationalContext<?> ctx, BeanManagerImpl manager, SlimAnnotatedType<?> type) {
        return InterceptionContext.of(interceptionModel, ctx, manager, METHOD_INTERCEPTION_TYPES, type);
    }

    private static InterceptionContext of(InterceptionModel interceptionModel, CreationalContext<?> ctx, BeanManagerImpl manager, Set<InterceptionType> interceptionTypes, SlimAnnotatedType<?> type) {
        return new InterceptionContext(InterceptionContext.initInterceptorInstanceMap(interceptionModel, ctx, manager, interceptionTypes), manager, interceptionModel, type);
    }

    private InterceptionContext(Map<Class<?>, Object> interceptorInstances, BeanManagerImpl manager, InterceptionModel interceptionModel, SlimAnnotatedType<?> type) {
        this.interceptorInstances = interceptorInstances;
        this.manager = manager;
        this.interceptionModel = interceptionModel;
        this.annotatedType = type;
    }

    private static Map<Class<?>, Object> initInterceptorInstanceMap(InterceptionModel model, CreationalContext ctx, BeanManagerImpl manager, Set<InterceptionType> interceptionTypes) {
        HashMap interceptorInstances = new HashMap();
        for (InterceptorClassMetadata<?> interceptor : model.getAllInterceptors()) {
            for (InterceptionType interceptionType : interceptionTypes) {
                if (!interceptor.isEligible(interceptionType)) continue;
                interceptorInstances.put(interceptor.getJavaClass(), interceptor.getInterceptorFactory().create(ctx, manager));
            }
        }
        return WeldCollections.immutableMap(interceptorInstances);
    }

    public InterceptionModel getInterceptionModel() {
        return this.interceptionModel;
    }

    public <T> T getInterceptorInstance(InterceptorClassMetadata<T> interceptorMetadata) {
        return Reflections.cast(this.interceptorInstances.get(interceptorMetadata.getJavaClass()));
    }

    private Object readResolve() throws ObjectStreamException {
        InterceptionModel interceptionModel = (InterceptionModel)this.manager.getInterceptorModelRegistry().get(this.annotatedType);
        return new InterceptionContext(this.interceptorInstances, this.manager, interceptionModel, this.annotatedType);
    }

    public List<InterceptorMethodInvocation> buildInterceptorMethodInvocations(Object instance, Method method, InterceptionType interceptionType) {
        List<InterceptorClassMetadata<?>> interceptorList = this.interceptionModel.getInterceptors(interceptionType, method);
        ArrayList<InterceptorMethodInvocation> interceptorInvocations = new ArrayList<InterceptorMethodInvocation>(interceptorList.size());
        for (InterceptorClassMetadata<?> interceptorMetadata : interceptorList) {
            interceptorInvocations.addAll(interceptorMetadata.getInterceptorInvocation(this.getInterceptorInstance(interceptorMetadata), interceptionType).getInterceptorMethodInvocations());
        }
        TargetClassInterceptorMetadata targetClassInterceptorMetadata = this.getInterceptionModel().getTargetClassInterceptorMetadata();
        if (targetClassInterceptorMetadata != null && targetClassInterceptorMetadata.isEligible(interceptionType)) {
            interceptorInvocations.addAll(targetClassInterceptorMetadata.getInterceptorInvocation(instance, interceptionType).getInterceptorMethodInvocations());
        }
        return ImmutableList.copyOf(interceptorInvocations);
    }

    public List<InterceptorMethodInvocation> buildInterceptorMethodInvocationsForConstructorInterception() {
        List<InterceptorClassMetadata<?>> interceptorList = this.interceptionModel.getConstructorInvocationInterceptors();
        ArrayList<InterceptorMethodInvocation> interceptorInvocations = new ArrayList<InterceptorMethodInvocation>(interceptorList.size());
        for (InterceptorClassMetadata<?> metadata : interceptorList) {
            Object interceptorInstance = this.getInterceptorInstance(metadata);
            InterceptorInvocation invocation = metadata.getInterceptorInvocation(interceptorInstance, InterceptionType.AROUND_CONSTRUCT);
            interceptorInvocations.addAll(invocation.getInterceptorMethodInvocations());
        }
        return ImmutableList.copyOf(interceptorInvocations);
    }
}

