/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.netty.transport;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import org.xnio.ChannelListener;
import org.xnio.IoFuture;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.netty.transport.AbstractXnioSocketChannel;
import org.xnio.netty.transport.XnioEventLoop;

public class XnioSocketChannel
extends AbstractXnioSocketChannel {
    private final OptionMap.Builder options = OptionMap.builder();
    private volatile StreamConnection channel;

    public XnioSocketChannel() {
        super(null);
        this.config().setTcpNoDelay(true);
    }

    @Override
    protected AbstractXnioSocketChannel.AbstractXnioUnsafe newUnsafe() {
        return new XnioUnsafe();
    }

    @Override
    protected <T> void setOption0(Option<T> option, T value) throws IOException {
        if (this.channel == null) {
            this.options.set(option, value);
        } else {
            this.channel.setOption(option, value);
        }
    }

    @Override
    protected <T> T getOption0(Option<T> option) throws IOException {
        if (this.channel == null) {
            return (T)this.options.getMap().get(option);
        }
        return (T)this.channel.getOption(option);
    }

    @Override
    protected StreamConnection connection() {
        return this.channel;
    }

    protected void doBind(SocketAddress localAddress) throws Exception {
        throw new UnsupportedOperationException("Not supported to bind in a separate step");
    }

    private final class XnioUnsafe
    extends AbstractXnioSocketChannel.AbstractXnioUnsafe {
        private XnioUnsafe() {
        }

        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            if (!this.ensureOpen(promise)) {
                return;
            }
            final boolean wasActive = XnioSocketChannel.this.isActive();
            XnioIoThread thread = ((XnioEventLoop)XnioSocketChannel.this.eventLoop()).ioThread();
            IoFuture future = localAddress == null ? thread.openStreamConnection(remoteAddress, null, null, XnioSocketChannel.this.options.getMap()) : thread.openStreamConnection(localAddress, remoteAddress, null, null, XnioSocketChannel.this.options.getMap());
            promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    if (channelFuture.isSuccess()) {
                        if (!wasActive && XnioSocketChannel.this.isActive()) {
                            XnioSocketChannel.this.pipeline().fireChannelActive();
                        }
                    } else {
                        XnioUnsafe.this.closeIfClosed();
                    }
                }
            });
            future.addNotifier((IoFuture.Notifier)new IoFuture.Notifier<StreamConnection, ChannelPromise>(){

                public void notify(IoFuture<? extends StreamConnection> ioFuture, ChannelPromise promise) {
                    IoFuture.Status status = ioFuture.getStatus();
                    if (status == IoFuture.Status.DONE) {
                        try {
                            XnioSocketChannel.this.channel = (StreamConnection)ioFuture.get();
                            XnioSocketChannel.this.channel.getSourceChannel().getReadSetter().set((ChannelListener)new AbstractXnioSocketChannel.ReadListener());
                            promise.setSuccess();
                            XnioSocketChannel.this.channel.getSourceChannel().resumeReads();
                        }
                        catch (Throwable cause) {
                            promise.setFailure(cause);
                        }
                    } else {
                        Exception error = status == IoFuture.Status.FAILED ? ioFuture.getException() : new CancellationException();
                        promise.setFailure((Throwable)error);
                    }
                }
            }, (Object)promise);
        }
    }
}

