/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.type;

import java.nio.ByteBuffer;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.type.DataType;

public class StringDataType
implements DataType {
    public static final StringDataType INSTANCE = new StringDataType();

    @Override
    public int compare(Object object, Object object2) {
        return object.toString().compareTo(object2.toString());
    }

    @Override
    public int getMemory(Object object) {
        return 24 + 2 * object.toString().length();
    }

    @Override
    public String read(ByteBuffer byteBuffer) {
        int n = DataUtils.readVarInt(byteBuffer);
        return DataUtils.readString(byteBuffer, n);
    }

    @Override
    public ByteBuffer write(ByteBuffer byteBuffer, Object object) {
        String string = object.toString();
        int n = string.length();
        DataUtils.writeVarInt(byteBuffer, n);
        return DataUtils.writeStringData(byteBuffer, string, n);
    }
}

