/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.api.connectionmanager.pool;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class PoolConfiguration {
    private AtomicInteger minSize = new AtomicInteger(0);
    private AtomicInteger initialSize = null;
    private AtomicInteger maxSize = new AtomicInteger(20);
    private AtomicLong blockingTimeout = new AtomicLong(30000L);
    private AtomicInteger idleTimeoutMinutes = new AtomicInteger(30);
    private AtomicBoolean validateOnMatch = new AtomicBoolean(false);
    private AtomicBoolean backgroundValidation = new AtomicBoolean(false);
    private AtomicLong backgroundValidationMillis = new AtomicLong(0L);
    private AtomicBoolean prefill = new AtomicBoolean(false);
    private AtomicBoolean strictMin = new AtomicBoolean(false);
    private AtomicBoolean useFastFail = new AtomicBoolean(false);
    private AtomicBoolean fair = new AtomicBoolean(true);

    public int getMinSize() {
        if (this.minSize.get() > this.maxSize.get()) {
            return this.maxSize.get();
        }
        return this.minSize.get();
    }

    public void setMinSize(int minSize) {
        this.minSize.set(minSize);
    }

    public int getInitialSize() {
        if (this.initialSize == null) {
            return this.getMinSize();
        }
        if (this.initialSize.get() > this.maxSize.get()) {
            return this.maxSize.get();
        }
        return this.initialSize.get();
    }

    public void setInitialSize(int initialSize) {
        if (this.initialSize == null) {
            this.initialSize = new AtomicInteger(0);
        }
        this.initialSize.set(initialSize);
    }

    public int getMaxSize() {
        if (this.maxSize.get() < this.minSize.get()) {
            return this.minSize.get();
        }
        return this.maxSize.get();
    }

    public void setMaxSize(int maxSize) {
        this.maxSize.set(maxSize);
    }

    public long getBlockingTimeout() {
        return this.blockingTimeout.get();
    }

    public void setBlockingTimeout(long blockingTimeout) {
        this.blockingTimeout.set(blockingTimeout);
    }

    public int getIdleTimeoutMinutes() {
        return this.idleTimeoutMinutes.get();
    }

    public void setIdleTimeoutMinutes(int idleTimeout) {
        this.idleTimeoutMinutes.set(idleTimeout);
    }

    public boolean isValidateOnMatch() {
        return this.validateOnMatch.get();
    }

    public void setValidateOnMatch(boolean v) {
        this.validateOnMatch.set(v);
    }

    public boolean isBackgroundValidation() {
        if (this.isValidateOnMatch()) {
            return false;
        }
        return this.backgroundValidation.get();
    }

    public void setBackgroundValidation(boolean v) {
        this.backgroundValidation.set(v);
    }

    public long getBackgroundValidationMillis() {
        return this.backgroundValidationMillis.get();
    }

    public void setBackgroundValidationMillis(long v) {
        this.backgroundValidationMillis.set(v);
    }

    public boolean isPrefill() {
        return this.prefill.get() || this.initialSize != null;
    }

    public void setPrefill(boolean prefill) {
        this.prefill.set(prefill);
    }

    public boolean isStrictMin() {
        return this.strictMin.get();
    }

    public void setStrictMin(boolean strictMin) {
        this.strictMin.set(strictMin);
    }

    public boolean isFair() {
        return this.fair.get();
    }

    public void setFair(boolean useFair) {
        this.fair.set(useFair);
    }

    public boolean isUseFastFail() {
        return this.useFastFail.get();
    }

    public void setUseFastFail(boolean useFastFail) {
        this.useFastFail.set(useFastFail);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PoolConfiguration@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[minSize=").append(this.minSize.get());
        sb.append(" initialSize=").append(this.initialSize != null ? Integer.valueOf(this.initialSize.get()) : "null");
        sb.append(" maxSize=").append(this.maxSize.get());
        sb.append(" blockingTimeout=").append(this.blockingTimeout.get());
        sb.append(" idleTimeoutMinutes=").append(this.idleTimeoutMinutes.get());
        sb.append(" validateOnMatch=").append(this.validateOnMatch.get());
        sb.append(" backgroundValidation=").append(this.backgroundValidation.get());
        sb.append(" backgroundValidationMillis=").append(this.backgroundValidationMillis.get());
        sb.append(" prefill=").append(this.prefill.get());
        sb.append(" strictMin=").append(this.strictMin.get());
        sb.append(" useFastFail=").append(this.useFastFail.get());
        sb.append(" fair=").append(this.fair.get());
        sb.append("]");
        return sb.toString();
    }
}

