/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.stat.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.engine.Version;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.classloading.spi.ClassLoadingException;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.stat.Statistics;
import org.hibernate.search.stat.spi.StatisticsImplementor;
import org.hibernate.search.util.impl.ClassLoaderHelper;

public class StatisticsImpl
implements Statistics,
StatisticsImplementor {
    private AtomicLong searchQueryCount = new AtomicLong();
    private AtomicLong searchExecutionTotalTime = new AtomicLong();
    private AtomicLong searchExecutionMaxTime = new AtomicLong();
    private volatile String queryExecutionMaxTimeQueryString;
    private AtomicLong objectLoadedCount = new AtomicLong();
    private AtomicLong objectLoadTotalTime = new AtomicLong();
    private AtomicLong objectLoadMaxTime = new AtomicLong();
    private volatile boolean isStatisticsEnabled;
    private final Lock readLock;
    private final Lock writeLock;
    private final ExtendedSearchIntegrator extendedIntegrator;

    public StatisticsImpl(ExtendedSearchIntegrator extendedIntegrator) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.extendedIntegrator = extendedIntegrator;
    }

    @Override
    public void clear() {
        this.searchQueryCount.set(0L);
        this.searchExecutionTotalTime.set(0L);
        this.searchExecutionMaxTime.set(0L);
        this.queryExecutionMaxTimeQueryString = "";
        this.objectLoadedCount.set(0L);
        this.objectLoadMaxTime.set(0L);
        this.objectLoadTotalTime.set(0L);
    }

    @Override
    public long getSearchQueryExecutionCount() {
        return this.searchQueryCount.get();
    }

    @Override
    public long getSearchQueryTotalTime() {
        return this.searchExecutionTotalTime.get();
    }

    @Override
    public long getSearchQueryExecutionMaxTime() {
        return this.searchExecutionMaxTime.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSearchQueryExecutionAvgTime() {
        this.writeLock.lock();
        try {
            long avgExecutionTime = 0L;
            if (this.searchQueryCount.get() > 0L) {
                avgExecutionTime = this.searchExecutionTotalTime.get() / this.searchQueryCount.get();
            }
            long l = avgExecutionTime;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public String getSearchQueryExecutionMaxTimeQueryString() {
        return this.queryExecutionMaxTimeQueryString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void searchExecuted(String searchString, long time) {
        this.readLock.lock();
        try {
            boolean isLongestQuery = false;
            long old = this.searchExecutionMaxTime.get();
            while (time > old && (isLongestQuery = this.searchExecutionMaxTime.compareAndSet(old, time))) {
                old = this.searchExecutionMaxTime.get();
            }
            if (isLongestQuery) {
                this.queryExecutionMaxTimeQueryString = searchString;
            }
            this.searchQueryCount.getAndIncrement();
            this.searchExecutionTotalTime.addAndGet(time);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getObjectsLoadedCount() {
        return this.objectLoadedCount.get();
    }

    @Override
    public long getObjectLoadingTotalTime() {
        return this.objectLoadTotalTime.get();
    }

    @Override
    public long getObjectLoadingExecutionMaxTime() {
        return this.objectLoadMaxTime.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getObjectLoadingExecutionAvgTime() {
        this.writeLock.lock();
        try {
            long avgLoadingTime = 0L;
            if (this.objectLoadedCount.get() > 0L) {
                avgLoadingTime = this.objectLoadTotalTime.get() / this.objectLoadedCount.get();
            }
            long l = avgLoadingTime;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void objectLoadExecuted(long numberOfObjectsLoaded, long time) {
        this.readLock.lock();
        try {
            long old = this.objectLoadMaxTime.get();
            while (time > old && this.objectLoadMaxTime.compareAndSet(old, time)) {
                old = this.objectLoadMaxTime.get();
            }
            this.objectLoadedCount.addAndGet(numberOfObjectsLoaded);
            this.objectLoadTotalTime.addAndGet(time);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean b) {
        this.isStatisticsEnabled = b;
    }

    @Override
    public String getSearchVersion() {
        return Version.getVersionString();
    }

    @Override
    public Set<String> getIndexedClassNames() {
        HashSet<String> indexedClasses = new HashSet<String>();
        for (Class<?> clazz : this.extendedIntegrator.getIndexBindings().keySet()) {
            indexedClasses.add(clazz.getName());
        }
        return indexedClasses;
    }

    @Override
    public int getNumberOfIndexedEntities(String entity) {
        Class<?> clazz = this.getEntityClass(entity);
        IndexReader indexReader = this.extendedIntegrator.getIndexReaderAccessor().open(clazz);
        try {
            IndexSearcher searcher = new IndexSearcher(indexReader);
            BooleanQuery boolQuery = new BooleanQuery();
            boolQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.FILTER);
            boolQuery.add((Query)new TermQuery(new Term("_hibernate_class", entity)), BooleanClause.Occur.FILTER);
            try {
                TopDocs topdocs = searcher.search((Query)boolQuery, 1);
                int n = topdocs.totalHits;
                return n;
            }
            catch (IOException e) {
                throw new SearchException("Unable to execute count query for entity " + entity, e);
            }
        }
        finally {
            this.extendedIntegrator.getIndexReaderAccessor().close(indexReader);
        }
    }

    @Override
    public Map<String, Integer> indexedEntitiesCount() {
        HashMap<String, Integer> countPerEntity = new HashMap<String, Integer>();
        for (String className : this.getIndexedClassNames()) {
            countPerEntity.put(className, this.getNumberOfIndexedEntities(className));
        }
        return countPerEntity;
    }

    private Class<?> getEntityClass(String entity) {
        Class clazz;
        try {
            clazz = ClassLoaderHelper.classForName(entity, this.extendedIntegrator.getServiceManager());
        }
        catch (ClassLoadingException e) {
            throw new IllegalArgumentException(entity + "not a indexed entity");
        }
        return clazz;
    }
}

