/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.infinispan.subsystem.BackupForResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BackupResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BinaryTableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LockingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.PartitionHandlingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringTableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;
import org.wildfly.clustering.service.SubGroupServiceNameFactory;

public enum CacheComponent implements SubGroupServiceNameFactory
{
    EVICTION(EvictionResourceDefinition.PATH),
    EXPIRATION(ExpirationResourceDefinition.PATH),
    LOCKING(LockingResourceDefinition.PATH),
    PERSISTENCE(StoreResourceDefinition.WILDCARD_PATH),
    STATE_TRANSFER(StateTransferResourceDefinition.PATH),
    PARTITION_HANDLING(PartitionHandlingResourceDefinition.PATH),
    STORE_WRITE(StoreWriteResourceDefinition.WILDCARD_PATH),
    TRANSACTION(TransactionResourceDefinition.PATH),
    BINARY_TABLE(StoreResourceDefinition.WILDCARD_PATH, BinaryTableResourceDefinition.PATH),
    STRING_TABLE(StoreResourceDefinition.WILDCARD_PATH, StringTableResourceDefinition.PATH),
    BACKUPS(BackupResourceDefinition.WILDCARD_PATH),
    BACKUP_FOR(BackupForResourceDefinition.PATH);

    private final String[] components;

    private CacheComponent(PathElement ... paths) {
        this.components = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            PathElement path = paths[i];
            this.components[i] = path.isWildcard() ? path.getKey() : path.getValue();
        }
    }

    public ServiceName getServiceName(String container) {
        return this.getServiceName(container, "default");
    }

    public ServiceName getServiceName(String container, String cache) {
        return CacheServiceName.CONFIGURATION.getServiceName(container, cache).append(this.components);
    }
}

