/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Arrays;
import javax.sql.DataSource;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.jboss.as.clustering.controller.CapabilityReference;
import org.jboss.as.clustering.controller.RequiredCapability;
import org.jboss.as.clustering.controller.Requirement;
import org.jboss.as.clustering.controller.transform.LegacyPropertyAddOperationTransformer;
import org.jboss.as.clustering.controller.transform.OperationTransformer;
import org.jboss.as.clustering.controller.transform.SimpleAttributeConverter;
import org.jboss.as.clustering.controller.transform.SimpleOperationTransformer;
import org.jboss.as.clustering.controller.validation.EnumValidatorBuilder;
import org.jboss.as.clustering.controller.validation.ParameterValidatorBuilder;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class JDBCStoreResourceDefinition
extends StoreResourceDefinition {
    static SimpleAttributeDefinitionBuilder createBuilder(String name, ModelType type, boolean allowNull) {
        return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowNull(allowNull)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES});
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder builder) {
        if (InfinispanModel.VERSION_4_0_0.requiresTransformation(version)) {
            SimpleAttributeConverter.Converter converter = new SimpleAttributeConverter.Converter(){

                public void convert(PathAddress address, String name, ModelNode value, ModelNode model, TransformationContext context) {
                    if (value.isDefined()) {
                        PathAddress rootAddress = address.subAddress(0, address.size() - 4);
                        PathAddress subsystemAddress = rootAddress.append(new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"datasources")});
                        Resource subsystem = context.readResourceFromRoot(subsystemAddress);
                        String poolName = value.asString();
                        for (String type : Arrays.asList("data-source", "xa-data-source")) {
                            if (!subsystem.hasChildren(type)) continue;
                            for (Resource.ResourceEntry entry : subsystem.getChildren(type)) {
                                if (!entry.getName().equals(poolName)) continue;
                                value.set(entry.getModel().get("jndi-name"));
                                return;
                            }
                        }
                    }
                }
            };
            ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRename(Attribute.DATA_SOURCE.getDefinition().getName(), DeprecatedAttribute.DATASOURCE.getDefinition().getName())).setValueConverter((AttributeConverter)new SimpleAttributeConverter(converter), new AttributeDefinition[]{Attribute.DATA_SOURCE.getDefinition()});
        }
        if (InfinispanModel.VERSION_3_0_0.requiresTransformation(version)) {
            builder.addOperationTransformationOverride("add").setCustomOperationTransformer((org.jboss.as.controller.transform.OperationTransformer)new SimpleOperationTransformer((OperationTransformer)new LegacyPropertyAddOperationTransformer())).inheritResourceAttributeDefinitions();
        }
        if (InfinispanModel.VERSION_2_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{Attribute.DIALECT.getDefinition()})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Attribute.DIALECT.getDefinition()})).end();
        }
        StoreResourceDefinition.buildTransformation(version, builder);
    }

    static void translateAddOperation(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined(Attribute.DATA_SOURCE.getDefinition().getName())) {
            if (operation.hasDefined(DeprecatedAttribute.DATASOURCE.getDefinition().getName())) {
                String jndiName = DeprecatedAttribute.DATASOURCE.getDefinition().resolveModelAttribute(context, operation).asString();
                String poolName = JDBCStoreResourceDefinition.findPoolName(context, jndiName);
                operation.get(Attribute.DATA_SOURCE.getDefinition().getName()).set(poolName);
            } else {
                throw ControllerLogger.MGMT_OP_LOGGER.validationFailedRequiredParameterNotPresent(Attribute.DATA_SOURCE.getDefinition().getName(), operation.toString());
            }
        }
    }

    private static String findPoolName(OperationContext context, String jndiName) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress rootAddress = address.subAddress(0, address.size() - 4);
        PathAddress subsystemAddress = rootAddress.append(new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"datasources")});
        Resource subsystem = context.readResourceFromRoot(subsystemAddress);
        for (String type : Arrays.asList("data-source", "xa-data-source")) {
            if (!subsystem.hasChildren(type)) continue;
            for (Resource.ResourceEntry entry : subsystem.getChildren(type)) {
                ModelNode model = entry.getModel();
                if (!model.get("jndi-name").asString().equals(jndiName)) continue;
                return entry.getName();
            }
        }
        throw InfinispanLogger.ROOT_LOGGER.dataSourceJndiNameNotFound(jndiName);
    }

    JDBCStoreResourceDefinition(PathElement path, InfinispanResourceDescriptionResolver resolver, boolean allowRuntimeOnlyRegistration) {
        super(path, (ResourceDescriptionResolver)resolver, allowRuntimeOnlyRegistration);
    }

    static enum DeprecatedAttribute implements org.jboss.as.clustering.controller.Attribute
    {
        DATASOURCE("datasource", ModelType.STRING, InfinispanModel.VERSION_4_0_0);

        private final AttributeDefinition definition;

        private DeprecatedAttribute(String name, ModelType type, InfinispanModel deprecation) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)JDBCStoreResourceDefinition.createBuilder(name, type, true).setAllowExpression(true)).setDeprecated(deprecation.getVersion())).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        DATA_SOURCE("data-source", ModelType.STRING, (CapabilityReferenceRecorder)new CapabilityReference((Requirement)RequiredCapability.DATA_SOURCE, (org.jboss.as.clustering.controller.Capability)Capability.DATA_SOURCE)),
        DIALECT("dialect", ModelType.STRING, (ParameterValidatorBuilder)new EnumValidatorBuilder(DatabaseType.class));

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, CapabilityReferenceRecorder reference) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)JDBCStoreResourceDefinition.createBuilder(name, type, true).setAllowExpression(false)).setCapabilityReference(reference)).build();
        }

        private Attribute(String name, ModelType type, ParameterValidatorBuilder validator) {
            SimpleAttributeDefinitionBuilder builder = (SimpleAttributeDefinitionBuilder)JDBCStoreResourceDefinition.createBuilder(name, type, true).setAllowExpression(true);
            this.definition = ((SimpleAttributeDefinitionBuilder)builder.setValidator(validator.configure((AbstractAttributeDefinitionBuilder)builder).build())).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static enum Capability implements org.jboss.as.clustering.controller.Capability
    {
        DATA_SOURCE("org.wildfly.clustering.infinispan.cache-container.cache.store.jdbc.data-source", DataSource.class);

        private final RuntimeCapability<Void> definition;

        private Capability(String name, Class<?> serviceType) {
            this.definition = RuntimeCapability.Builder.of((String)name, (boolean)true).setServiceType(serviceType).build();
        }

        public RuntimeCapability<Void> getDefinition() {
            return this.definition;
        }

        public RuntimeCapability<Void> getRuntimeCapability(PathAddress address) {
            PathAddress cacheAddress = address.getParent();
            PathAddress containerAddress = cacheAddress.getParent();
            return this.definition.fromBaseCapability(containerAddress.getLastElement().getValue() + "." + cacheAddress.getLastElement().getValue());
        }
    }
}

