/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.service;

import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jpa.config.ExtendedPersistenceInheritance;
import org.jboss.as.jpa.management.DynamicManagementStatisticsResource;
import org.jboss.as.jpa.management.EntityManagerFactoryLookup;
import org.jboss.as.jpa.management.ManagementResourceDefinition;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.processor.CacheDeploymentHelper;
import org.jboss.as.jpa.processor.PersistenceUnitServiceHandler;
import org.jboss.as.jpa.service.JPAUserTransactionListenerService;
import org.jboss.as.jpa.subsystem.JPAExtension;
import org.jboss.as.jpa.util.JPAServiceNames;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jipijapa.management.spi.Statistics;
import org.jipijapa.plugin.spi.ManagementAdaptor;

public class JPAService
implements Service<Void> {
    public static final ServiceName SERVICE_NAME = JPAServiceNames.getJPAServiceName();
    private static volatile String defaultDataSourceName = null;
    private static volatile ExtendedPersistenceInheritance defaultExtendedPersistenceInheritance = null;
    private static final Set<String> existingResourceDescriptionResolver = new HashSet<String>();
    private final CacheDeploymentHelper cacheDeploymentHelper = new CacheDeploymentHelper();

    public static String getDefaultDataSourceName() {
        JpaLogger.ROOT_LOGGER.tracef("JPAService.getDefaultDataSourceName() == %s", defaultDataSourceName);
        return defaultDataSourceName;
    }

    public static void setDefaultDataSourceName(String dataSourceName) {
        JpaLogger.ROOT_LOGGER.tracef("JPAService.setDefaultDataSourceName(%s), previous value = %s", dataSourceName, defaultDataSourceName);
        defaultDataSourceName = dataSourceName;
    }

    public static ExtendedPersistenceInheritance getDefaultExtendedPersistenceInheritance() {
        JpaLogger.ROOT_LOGGER.tracef("JPAService.getDefaultExtendedPersistenceInheritance() == %s", defaultExtendedPersistenceInheritance.toString());
        return defaultExtendedPersistenceInheritance;
    }

    public static void setDefaultExtendedPersistenceInheritance(ExtendedPersistenceInheritance defaultExtendedPersistenceInheritance) {
        JpaLogger.ROOT_LOGGER.tracef("JPAService.setDefaultExtendedPersistenceInheritance(%s)", defaultExtendedPersistenceInheritance.toString());
        JPAService.defaultExtendedPersistenceInheritance = defaultExtendedPersistenceInheritance;
    }

    public static void addService(ServiceTarget target, String defaultDataSourceName, ExtendedPersistenceInheritance defaultExtendedPersistenceInheritance) {
        JPAService jpaService = new JPAService();
        JPAService.setDefaultDataSourceName(defaultDataSourceName);
        JPAService.setDefaultExtendedPersistenceInheritance(defaultExtendedPersistenceInheritance);
        target.addService(SERVICE_NAME, (Service)jpaService).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(JPAUserTransactionListenerService.SERVICE_NAME).install();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource createManagementStatisticsResource(ManagementAdaptor managementAdaptor, String scopedPersistenceUnitName, DeploymentUnit deploymentUnit) {
        Set<String> set = existingResourceDescriptionResolver;
        synchronized (set) {
            EntityManagerFactoryLookup entityManagerFactoryLookup = new EntityManagerFactoryLookup();
            Statistics statistics = managementAdaptor.getStatistics();
            if (!existingResourceDescriptionResolver.contains(managementAdaptor.getVersion())) {
                StandardResourceDescriptionResolver resourceDescriptionResolver = new StandardResourceDescriptionResolver(statistics.getResourceBundleKeyPrefix(), statistics.getResourceBundleName(), statistics.getClass().getClassLoader()){
                    private ResourceDescriptionResolver fallback = JPAExtension.getResourceDescriptionResolver(new String[0]);

                    public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle) {
                        if (bundle.containsKey(this.getBundleKey(new String[]{attributeName}))) {
                            return super.getResourceAttributeDescription(attributeName, locale, bundle);
                        }
                        return this.fallback.getResourceAttributeDescription(attributeName, locale, this.fallback.getResourceBundle(locale));
                    }
                };
                PathElement subsystemPE = PathElement.pathElement((String)"subsystem", (String)"jpa");
                ManagementResourceRegistration deploymentResourceRegistration = (ManagementResourceRegistration)deploymentUnit.getAttachment(DeploymentModelUtils.MUTABLE_REGISTRATION_ATTACHMENT);
                ManagementResourceRegistration deploymentSubsystemRegistration = deploymentResourceRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{subsystemPE}));
                ManagementResourceRegistration subdeploymentSubsystemRegistration = deploymentResourceRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subdeployment"), subsystemPE}));
                ManagementResourceRegistration providerResource = deploymentSubsystemRegistration.registerSubModel((ResourceDefinition)new ManagementResourceDefinition(PathElement.pathElement((String)managementAdaptor.getIdentificationLabel()), (ResourceDescriptionResolver)resourceDescriptionResolver, statistics, entityManagerFactoryLookup));
                providerResource.registerReadOnlyAttribute(PersistenceUnitServiceHandler.SCOPED_UNIT_NAME, null);
                providerResource = subdeploymentSubsystemRegistration.registerSubModel((ResourceDefinition)new ManagementResourceDefinition(PathElement.pathElement((String)managementAdaptor.getIdentificationLabel()), (ResourceDescriptionResolver)resourceDescriptionResolver, statistics, entityManagerFactoryLookup));
                providerResource.registerReadOnlyAttribute(PersistenceUnitServiceHandler.SCOPED_UNIT_NAME, null);
                existingResourceDescriptionResolver.add(managementAdaptor.getVersion());
            }
            return new DynamicManagementStatisticsResource(statistics, scopedPersistenceUnitName, managementAdaptor.getIdentificationLabel(), entityManagerFactoryLookup);
        }
    }

    public void start(StartContext startContext) throws StartException {
        this.cacheDeploymentHelper.register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext stopContext) {
        this.cacheDeploymentHelper.unregister();
        Set<String> set = existingResourceDescriptionResolver;
        synchronized (set) {
            existingResourceDescriptionResolver.clear();
        }
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }
}

